/*
 * Decompiled with CFR 0.152.
 */
package io.dflabs.lib.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ClipData;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.annotation.StringRes;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import io.dflabs.lib.interfaces.OnPhotoPhotoImport;
import io.dflabs.lib.interfaces.OnPhotoTaken;
import io.dflabs.lib.utils.CameraImportTask;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CameraUtils {
    public static final int REQUEST_TAKE_PHOTO = 2457;
    public static final int REQUEST_IMPORT_PHOTO = 2456;
    OnPhotoPhotoImport onPhotoPhotoImport;
    private File photoFile;
    private OnPhotoTaken onPhotoTaken;
    private Context context;

    public void takePhoto(AppCompatActivity context, OnPhotoTaken onPhotoTaken) {
        this.context = context;
        this.onPhotoTaken = onPhotoTaken;
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(context.getPackageManager()) != null) {
            try {
                this.photoFile = this.createImageFile();
            }
            catch (IOException e) {
                onPhotoTaken.onPhotoError(e);
            }
            if (this.photoFile != null) {
                takePictureIntent.putExtra("output", (Parcelable)Uri.fromFile((File)this.photoFile));
                context.startActivityForResult(takePictureIntent, 2457);
            }
        } else {
            onPhotoTaken.onPhotoError(new IllegalStateException("Not camera app installed"));
        }
    }

    public void takePhoto(Fragment context, OnPhotoTaken onPhotoTaken) {
        this.context = context.getContext();
        this.onPhotoTaken = onPhotoTaken;
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(this.context.getPackageManager()) != null) {
            try {
                this.photoFile = this.createImageFile();
            }
            catch (IOException e) {
                onPhotoTaken.onPhotoError(e);
            }
            if (this.photoFile != null) {
                takePictureIntent.putExtra("output", (Parcelable)Uri.fromFile((File)this.photoFile));
                context.startActivityForResult(takePictureIntent, 2457);
            }
        } else {
            onPhotoTaken.onPhotoError(new IllegalStateException("Not camera app installed"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importPhoto(AppCompatActivity context, @StringRes int message, OnPhotoPhotoImport callback, boolean allowMultiple) {
        this.context = context;
        this.onPhotoPhotoImport = callback;
        if (callback == null) {
            throw new NullPointerException("OnMultiplePhotoImport must not be null");
        }
        if (allowMultiple) {
            if (Build.VERSION.SDK_INT < 18) throw new IllegalArgumentException("Multiple import require minimum API 18");
            Intent intent = new Intent();
            intent.setType("image/video");
            intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
            intent.setAction("android.intent.action.GET_CONTENT");
            context.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)context.getString(message)), 2456);
            return;
        } else {
            Intent i = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
            context.startActivityForResult(i, 2456);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importPhoto(Fragment context, @StringRes int message, OnPhotoPhotoImport callback, boolean allowMultiple) {
        this.context = context.getContext();
        this.onPhotoPhotoImport = callback;
        if (callback == null) {
            throw new NullPointerException("OnMultiplePhotoImport must not be null");
        }
        if (allowMultiple) {
            if (Build.VERSION.SDK_INT < 18) throw new IllegalArgumentException("Multiple import require minimum API 18");
            Intent intent = new Intent();
            intent.setType("image/video");
            intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
            intent.setAction("android.intent.action.GET_CONTENT");
            context.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)context.getString(message)), 2456);
            return;
        } else {
            Intent i = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
            context.startActivityForResult(i, 2456);
        }
    }

    public void importMedia(Fragment context, @StringRes int message, OnPhotoPhotoImport callback) {
        this.context = context.getContext();
        this.onPhotoPhotoImport = callback;
        if (callback == null) {
            throw new NullPointerException("OnMultiplePhotoImport must not be null");
        }
        Intent intent = new Intent();
        intent.setType("image/video");
        intent.setAction("android.intent.action.GET_CONTENT");
        context.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)context.getString(message)), 2456);
    }

    @TargetApi(value=16)
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 2457) {
            if (resultCode == -1) {
                this.onPhotoTaken.onPhotoSuccess(this.fullBitmap(), this.photoFile);
            }
        } else if (requestCode == 2456 && resultCode == -1 && null != data) {
            Uri selectedFile = data.getData();
            if (selectedFile != null) {
                ContentResolver contentResolver = this.context.getContentResolver();
                String mediaType = contentResolver.getType(selectedFile);
                if (mediaType != null) {
                    if (mediaType.contains("image")) {
                        CameraImportTask task = new CameraImportTask(this.context, new Uri[]{selectedFile}, this.onPhotoPhotoImport);
                        task.execute(new Void[0]);
                    } else if (mediaType.contains("video")) {
                        File file = new File(CameraImportTask.getRealPathFromURI(this.context, selectedFile));
                        this.onPhotoPhotoImport.onVideoImport(file);
                    } else {
                        this.onPhotoPhotoImport.onErrorImport(new RuntimeException("Incompatible media type"));
                        Log.d((String)"Error", (String)"Incompatible media type");
                    }
                } else {
                    this.onPhotoPhotoImport.onErrorImport(new RuntimeException("Media type null"));
                    Log.d((String)"Error", (String)"Media type null");
                }
            } else {
                ClipData clipData = data.getClipData();
                if (clipData != null) {
                    Uri[] uris = new Uri[clipData.getItemCount()];
                    for (int i = 0; i < clipData.getItemCount(); ++i) {
                        uris[i] = clipData.getItemAt(i).getUri();
                    }
                    CameraImportTask task = new CameraImportTask(this.context, uris, this.onPhotoPhotoImport);
                    task.execute(new Void[0]);
                }
            }
        }
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private File createImageFile() throws IOException {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_";
        File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        return File.createTempFile(imageFileName, ".jpg", storageDir);
    }

    private Bitmap fullBitmap() {
        try {
            BitmapFactory.Options bmOptions = new BitmapFactory.Options();
            bmOptions.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)this.photoFile.getAbsolutePath(), (BitmapFactory.Options)bmOptions);
            int photoW = bmOptions.outWidth;
            int photoH = bmOptions.outHeight;
            int scaleFactor = Math.min(photoW / 300, photoH / 300);
            bmOptions.inJustDecodeBounds = false;
            bmOptions.inSampleSize = scaleFactor;
            return BitmapFactory.decodeFile((String)this.photoFile.getAbsolutePath(), (BitmapFactory.Options)bmOptions);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

