/*
 * Decompiled with CFR 0.152.
 */
package io.dflabs.lib.mvp;

import android.os.Bundle;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.RecyclerView;
import android.view.InflateException;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;
import io.dflabs.lib.mvp.BaseFragment;
import io.dflabs.lib.ui.SuperRecyclerView;
import java.util.List;

public abstract class RecyclerFragment<T, R extends RecyclerView.Adapter>
extends BaseFragment {
    protected RecyclerView mRecyclerView;
    TextView mEmptyTextView;
    FrameLayout mEmptyLayout;
    protected SwipeRefreshLayout mSwipeRefreshLayout;
    protected SwipeRefreshLayout.OnRefreshListener mOnRefreshListener;
    protected R mAdapter;

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        SuperRecyclerView superRecyclerView = (SuperRecyclerView)view.findViewWithTag((Object)"super_recycler_view_tag");
        if (superRecyclerView == null) {
            throw new InflateException("You must add <io.dflabs.lib.ui.SuperRecyclerView /> in your view");
        }
        this.mRecyclerView = superRecyclerView.getRecyclerView();
        this.mEmptyTextView = superRecyclerView.getEmptyTextView();
        this.mEmptyLayout = superRecyclerView.getEmptyLayout();
        this.mSwipeRefreshLayout = superRecyclerView.getSwipeToRefreshLayout();
    }

    protected void setLayoutManager(RecyclerView.LayoutManager layoutManager) {
        this.mRecyclerView.setLayoutManager(layoutManager);
    }

    protected void setItemAnimator(RecyclerView.ItemAnimator itemAnimator) {
        this.mRecyclerView.setItemAnimator(itemAnimator);
    }

    protected void setEmptyView(View v) {
        this.mEmptyLayout.removeAllViews();
        this.mEmptyLayout.addView(v);
    }

    protected void setEmptyText(int text) {
        this.mEmptyTextView.setText(text);
    }

    protected void setOnRefreshListener(SwipeRefreshLayout.OnRefreshListener onRefreshListener) {
        this.mOnRefreshListener = onRefreshListener;
        this.mSwipeRefreshLayout.setOnRefreshListener(this.mOnRefreshListener);
    }

    protected void setAdapter(R adapter) {
        this.mAdapter = adapter;
        this.mRecyclerView.setAdapter(this.mAdapter);
    }

    protected void addItems(List<T> collection) {
        this.mEmptyLayout.setVisibility(collection.size() == 0 ? 0 : 8);
        this.mRecyclerView.setVisibility(collection.size() > 0 ? 0 : 8);
        ((SuperRecyclerAdapter)this.mAdapter).addAll(collection);
    }

    protected void notifyDataSetChanged() {
        this.mAdapter.notifyDataSetChanged();
    }

    protected void startRefreshing() {
        this.mSwipeRefreshLayout.post(new Runnable(){

            @Override
            public void run() {
                RecyclerFragment.this.mSwipeRefreshLayout.setRefreshing(true);
                RecyclerFragment.this.mOnRefreshListener.onRefresh();
            }
        });
    }

    protected void stopRefreshing() {
        this.mSwipeRefreshLayout.setRefreshing(false);
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.mOnRefreshListener == null) {
            throw new NullPointerException("You must call setOnRefreshListener() within onViewCreated | onActivityCreated");
        }
        if (this.mAdapter == null) {
            throw new NullPointerException("You must call setAdapter() within onViewCreated | onActivityCreated");
        }
    }

    public static interface SuperRecyclerAdapter<T> {
        public void addAll(List<T> var1);
    }
}

