/*
 * Decompiled with CFR 0.152.
 */
package io.dflabs.lib.utils;

import android.content.Context;
import com.google.gson.Gson;

public class Prefs {
    private static String PREFS_NAME;
    private static Prefs singleton;
    private Context context;

    public Prefs(Context context) {
        this.context = context;
        PREFS_NAME = context.getPackageName();
    }

    public static void setDefaultContext(Context context) {
        Prefs.with(context);
    }

    public static Prefs instance() {
        if (singleton == null || Prefs.singleton.context == null) {
            throw new IllegalArgumentException("Call setDefaultContext(context) first");
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Prefs with(Context context) {
        if (singleton != null) return singleton;
        Class<Prefs> clazz = Prefs.class;
        synchronized (Prefs.class) {
            if (singleton != null) return singleton;
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null");
            }
            singleton = new Prefs(context);
            Prefs.singleton.context = context.getApplicationContext();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public int integer(String key) {
        return this.context.getSharedPreferences(PREFS_NAME, 0).getInt(key, -1);
    }

    public int integer(String key, int defaultValue) {
        return this.context.getSharedPreferences(PREFS_NAME, 0).getInt(key, defaultValue);
    }

    public String string(String key) {
        return this.context.getSharedPreferences(PREFS_NAME, 0).getString(key, "");
    }

    public String string(String key, String defaultValue) {
        return this.context.getSharedPreferences(PREFS_NAME, 0).getString(key, defaultValue);
    }

    public boolean bool(String key) {
        return this.context.getSharedPreferences(PREFS_NAME, 0).getBoolean(key, false);
    }

    public boolean bool(String key, boolean defaultValue) {
        return this.context.getSharedPreferences(PREFS_NAME, 0).getBoolean(key, defaultValue);
    }

    public long number(String key) {
        return this.context.getSharedPreferences(PREFS_NAME, 0).getLong(key, -1L);
    }

    public long number(String key, long defaultValue) {
        return this.context.getSharedPreferences(PREFS_NAME, 0).getLong(key, defaultValue);
    }

    public Object object(String key, Class<?> fromClass) {
        try {
            String json = this.context.getSharedPreferences(PREFS_NAME, 0).getString(key, null);
            if (json != null) {
                Gson gson = new Gson();
                return gson.fromJson(json, fromClass);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void putInt(String key, int value) {
        this.context.getSharedPreferences(PREFS_NAME, 0).edit().putInt(key, value).commit();
    }

    public void putBool(String key, boolean value) {
        this.context.getSharedPreferences(PREFS_NAME, 0).edit().putBoolean(key, value).commit();
    }

    public void putString(String key, String value) {
        this.context.getSharedPreferences(PREFS_NAME, 0).edit().putString(key, value).commit();
    }

    public void putLong(String key, long value) {
        this.context.getSharedPreferences(PREFS_NAME, 0).edit().putLong(key, value).commit();
    }

    public void putObject(String key, Object value, Class<?> fromClass) {
        try {
            Gson gson = new Gson();
            String json = gson.toJson(value, fromClass);
            this.context.getSharedPreferences(PREFS_NAME, 0).edit().putString(key, json).commit();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Only plain objects are supported");
        }
    }
}

