/*
 * Decompiled with CFR 0.152.
 */
package io.dflabs.lib.ui;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.ColorRes;
import android.support.annotation.StringRes;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import io.dflabs.lib.adapters.RecyclerListAdapter;
import io.dflabs.lib.interfaces.OnLoadMoreItems;
import io.dflabs.lib.interfaces.OnRefreshItems;
import io.dflabs.lib.mvp.LoadMoreItems;
import io.dflabs.lib.mvp.RefreshItems;
import java.util.ArrayList;

public class SuperRecyclerView2
extends FrameLayout {
    public RecyclerView recyclerView;
    public SwipeRefreshLayout swipeRefreshLayout;
    public View emptyView;
    public View contentView;
    private RefreshItems swipeRefreshListener;

    public SuperRecyclerView2(Context context) {
        super(context);
    }

    public SuperRecyclerView2(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SuperRecyclerView2(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void startRefreshing() {
        if (this.swipeRefreshLayout != null && this.swipeRefreshListener != null) {
            this.swipeRefreshLayout.post(new Runnable(){

                @Override
                public void run() {
                    SuperRecyclerView2.this.swipeRefreshLayout.setRefreshing(true);
                    SuperRecyclerView2.this.swipeRefreshListener.onRefresh();
                }
            });
        }
    }

    public void endRefreshing() {
        if (this.swipeRefreshLayout != null) {
            this.swipeRefreshLayout.setRefreshing(false);
        }
    }

    public void startBottomRefreshing() {
        RecyclerListAdapter adapter = (RecyclerListAdapter)this.recyclerView.getAdapter();
        if (adapter != null) {
            adapter.startEndlessLoading();
        }
    }

    public void endBottomRefreshing() {
        RecyclerListAdapter adapter = (RecyclerListAdapter)this.recyclerView.getAdapter();
        if (adapter != null) {
            adapter.update(new ArrayList(), true);
        }
    }

    public static class Builder {
        Context context;
        private LinearLayoutManager layoutManager;
        private RecyclerListAdapter adapter;
        private DefaultItemAnimator animator;
        private boolean endlessScroll;
        private boolean pullToRefresh;
        private OnRefreshItems onRefreshItems;
        private String emptyMessage;
        private boolean empty;
        private View emptyView;
        @ColorRes
        private int emptyMessageColor;
        private float textSize;
        private OnLoadMoreItems loadMoreItems;

        public Builder(Context context) {
            this.context = context;
            if (context == null) {
                throw new NullPointerException("Context must not be null");
            }
            this.endlessScroll = false;
            this.pullToRefresh = true;
            this.empty = false;
        }

        public <T extends LinearLayoutManager> Builder layoutManager(T layoutManager) {
            this.layoutManager = layoutManager;
            return this;
        }

        public <A extends RecyclerListAdapter> Builder adapter(A adapter) {
            this.adapter = adapter;
            return this;
        }

        public <AN extends DefaultItemAnimator> Builder animator(AN animator) {
            this.animator = animator;
            return this;
        }

        public Builder endlessScroll(boolean enabled, OnLoadMoreItems callback) {
            this.endlessScroll = enabled;
            this.loadMoreItems = callback;
            return this;
        }

        public Builder pullToRefresh(boolean enabled, OnRefreshItems onRefreshItems) {
            this.pullToRefresh = enabled;
            this.onRefreshItems = onRefreshItems;
            return this;
        }

        public Builder emptyMessage(@StringRes int message, @ColorRes int messageColor, float textSize) {
            this.textSize = textSize;
            this.empty = true;
            this.emptyMessageColor = messageColor;
            this.emptyMessage = this.context.getString(message);
            return this;
        }

        public Builder emptyMessage(String message, @ColorRes int messageColor, float textSize) {
            this.textSize = textSize;
            this.empty = true;
            this.emptyMessageColor = messageColor;
            this.emptyMessage = message;
            return this;
        }

        public Builder emptyView(View view) {
            this.empty = true;
            this.emptyView = view;
            return this;
        }

        public SuperRecyclerView2 inflateIn(Activity activity) {
            SuperRecyclerView2 superRecyclerView = this.createSuperRecycler();
            activity.setContentView((View)superRecyclerView);
            return superRecyclerView;
        }

        public <V extends ViewGroup> SuperRecyclerView2 inflateIn(V parentView) {
            SuperRecyclerView2 superRecyclerView = this.createSuperRecycler();
            parentView.addView((View)superRecyclerView);
            return superRecyclerView;
        }

        public SuperRecyclerView2 create() {
            return this.createSuperRecycler();
        }

        private SuperRecyclerView2 createSuperRecycler() {
            SuperRecyclerView2 superRecyclerView2 = new SuperRecyclerView2(this.context);
            superRecyclerView2.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            superRecyclerView2.recyclerView = this.createRecycler();
            if (this.pullToRefresh) {
                superRecyclerView2.swipeRefreshLayout = new SwipeRefreshLayout(this.context);
                superRecyclerView2.swipeRefreshLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                superRecyclerView2.swipeRefreshLayout.addView((View)superRecyclerView2.recyclerView);
                if (this.onRefreshItems == null) {
                    throw new NullPointerException("Pull to Refresh feature needs OnRefreshItems to be implemented");
                }
                superRecyclerView2.swipeRefreshListener = new RefreshItems(this.onRefreshItems);
                superRecyclerView2.swipeRefreshLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)superRecyclerView2.swipeRefreshListener);
                superRecyclerView2.contentView = superRecyclerView2.swipeRefreshLayout;
                superRecyclerView2.addView((View)superRecyclerView2.swipeRefreshLayout);
            } else {
                superRecyclerView2.contentView = superRecyclerView2.recyclerView;
                superRecyclerView2.addView((View)superRecyclerView2.recyclerView);
            }
            if (this.empty) {
                superRecyclerView2.emptyView = this.createEmptyView();
                superRecyclerView2.addView(superRecyclerView2.emptyView);
            }
            return superRecyclerView2;
        }

        private View createEmptyView() {
            FrameLayout emptyLayout = new FrameLayout(this.context);
            emptyLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            if (this.emptyView != null) {
                ((ViewGroup)emptyLayout).addView(this.emptyView);
            } else {
                TextView emptyTextView = new TextView(this.context);
                emptyTextView.setGravity(17);
                emptyTextView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                emptyTextView.setText((CharSequence)this.emptyMessage);
                emptyTextView.setTextSize(this.textSize);
                emptyTextView.setTextColor(this.context.getResources().getColor(this.emptyMessageColor));
                emptyLayout = emptyTextView;
            }
            emptyLayout.setVisibility(8);
            return emptyLayout;
        }

        private RecyclerView createRecycler() {
            RecyclerView recyclerView = new RecyclerView(this.context);
            recyclerView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
            recyclerView.setItemAnimator((RecyclerView.ItemAnimator)this.animator);
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
            if (this.endlessScroll) {
                if (this.loadMoreItems != null) {
                    recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)new LoadMoreItems(this.adapter, this.layoutManager, this.loadMoreItems));
                } else {
                    throw new NullPointerException("Endless Scroll feature needs OnLoadMoreItems to be implemented");
                }
            }
            return recyclerView;
        }
    }
}

