/*
 * Decompiled with CFR 0.152.
 */
package io.dflabs.lib.mvp;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import io.dflabs.lib.adapters.RecyclerListAdapter;
import io.dflabs.lib.interfaces.OnLoadMoreItems;

public class LoadMoreItems
extends RecyclerView.OnScrollListener {
    private RecyclerListAdapter adapter;
    private final LinearLayoutManager mLinearLayoutManager;
    private OnLoadMoreItems onLoadMoreItems;
    private int previousTotal = 0;
    private boolean loading = true;
    int firstVisibleItem;
    int visibleItemCount;
    int totalItemCount;
    private int currentPage = 1;

    public LoadMoreItems(RecyclerListAdapter adapter, LinearLayoutManager linearLayoutManager, OnLoadMoreItems onLoadMoreItems) {
        this.adapter = adapter;
        this.mLinearLayoutManager = linearLayoutManager;
        this.onLoadMoreItems = onLoadMoreItems;
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
        this.visibleItemCount = recyclerView.getChildCount();
        this.totalItemCount = this.mLinearLayoutManager.getItemCount();
        this.firstVisibleItem = this.mLinearLayoutManager.findFirstVisibleItemPosition();
        if (this.loading && this.totalItemCount > this.previousTotal + 1) {
            this.loading = false;
            this.previousTotal = this.totalItemCount;
        }
        int visibleThreshold = 1;
        if (!this.loading && this.totalItemCount - this.visibleItemCount <= this.firstVisibleItem + visibleThreshold) {
            ++this.currentPage;
            this.adapter.startEndlessLoading();
            this.onLoadMoreItems.onLoadMoreItems(this.currentPage);
            this.loading = true;
        }
    }
}

