/*
 * Decompiled with CFR 0.152.
 */
package io.dflabs.lib.adapters;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import java.util.ArrayList;
import java.util.List;

public abstract class RecyclerListAdapter<T, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH> {
    private boolean endlessScrollActive = false;
    protected List<T> items = new ArrayList<T>();

    public void update(List<T> items, boolean appendBottom) {
        if (this.items == null) {
            this.items = new ArrayList<T>();
        }
        if (this.endlessScrollActive && this.items.size() > 0) {
            this.endlessScrollActive = false;
            this.items.remove(this.items.size() - 1);
        }
        if (appendBottom) {
            this.items.addAll(items);
        } else {
            this.items = items;
        }
        this.notifyDataSetChanged();
    }

    public int getItemViewType(int position) {
        if (this.items.get(position) == null) {
            return -1;
        }
        return super.getItemViewType(position);
    }

    public void onBindViewHolder(VH holder, int position) {
        if (this.items.get(position) == null) {
            ProgressViewHolder progressViewHolder = (ProgressViewHolder)((Object)holder);
            progressViewHolder.progressBar.setIndeterminate(true);
        } else {
            this.onBindViewHolder(holder, position, this.items.get(position));
        }
    }

    public VH onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == -1) {
            ProgressBar progressBar = new ProgressBar(parent.getContext(), null, 16842873);
            progressBar.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
            return (VH)((Object)new ProgressViewHolder((View)progressBar));
        }
        return this.onCreateViewHolder(parent, viewType, null);
    }

    protected abstract void onBindViewHolder(VH var1, int var2, T var3);

    protected abstract VH onCreateViewHolder(ViewGroup var1, int var2, RecyclerView var3);

    public int getItemCount() {
        return this.items.size();
    }

    public void startEndlessLoading() {
        this.endlessScrollActive = true;
        this.items.add(null);
        this.notifyDataSetChanged();
    }

    public class ProgressViewHolder
    extends RecyclerView.ViewHolder {
        ProgressBar progressBar;

        public ProgressViewHolder(View itemView) {
            super(itemView);
            this.progressBar = (ProgressBar)itemView;
        }
    }
}

