/*
 * Decompiled with CFR 0.152.
 */
package io.dflabs.lib.validators;

import android.support.design.widget.TextInputLayout;
import android.widget.EditText;
import io.dflabs.lib.validators.FormValidator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EditTextValidator
extends FormValidator.Validator {
    private final EditText editText;
    private final int errorMessage;
    private final Pattern pattern;

    public EditTextValidator(EditText editText, String regex, int errorMessage) {
        this.editText = editText;
        this.errorMessage = errorMessage;
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public boolean isValid() {
        Matcher matcher = this.pattern.matcher(this.editText.getText().toString().trim());
        return matcher.matches();
    }

    @Override
    public void showError() {
        this.error(this.errorMessage);
    }

    private void error(Integer message) {
        try {
            TextInputLayout textInputLayout = (TextInputLayout)this.editText.getParent();
            textInputLayout.setErrorEnabled(true);
            textInputLayout.setError(message != null ? this.context.getString(message.intValue()) : null);
        }
        catch (ClassCastException ignored) {
            this.editText.setError(message != null ? this.context.getString(message.intValue()) : null);
        }
    }

    @Override
    void stopError() {
        this.error(null);
    }
}

