/*
 * Decompiled with CFR 0.152.
 */
package io.dflabs.lib.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.AsyncTask;
import io.dflabs.lib.interfaces.OnPhotoPhotoImport;
import java.io.File;
import java.io.InputStream;

public class CameraImportTask
extends AsyncTask<Void, FileBitmap, Boolean> {
    private final Uri[] uris;
    private OnPhotoPhotoImport onPhotoPhotoImport;
    private final Context context;
    private Exception exception;

    public CameraImportTask(Context context, Uri[] uris, OnPhotoPhotoImport onPhotoPhotoImport) {
        this.context = context;
        this.uris = uris;
        this.onPhotoPhotoImport = onPhotoPhotoImport;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.onPhotoPhotoImport.onStartImport();
    }

    protected Boolean doInBackground(Void ... voids) {
        try {
            for (Uri uri : this.uris) {
                InputStream is = this.context.getContentResolver().openInputStream(uri);
                if (is == null) continue;
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is);
                this.publishProgress(new FileBitmap[]{new FileBitmap(bitmap, new File(uri.getPath()))});
                is.close();
            }
        }
        catch (Exception e) {
            this.exception = e;
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected void onProgressUpdate(FileBitmap ... values) {
        super.onProgressUpdate((Object[])values);
        this.onPhotoPhotoImport.onPhotoImport(values[0].bitmap, values[0].file);
    }

    protected void onPostExecute(Boolean aBoolean) {
        super.onPostExecute((Object)aBoolean);
        this.onPhotoPhotoImport.onErrorImport(this.exception);
    }

    class FileBitmap {
        Bitmap bitmap;
        File file;

        public FileBitmap(Bitmap bitmap, File file) {
            this.bitmap = bitmap;
            this.file = file;
        }
    }
}

