/*
 * Decompiled with CFR 0.152.
 */
package io.dflabs.lib.mvp;

import android.os.Bundle;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.RecyclerView;
import android.view.InflateException;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;
import io.dflabs.lib.adapters.RecyclerListAdapter;
import io.dflabs.lib.mvp.BaseFragment;
import io.dflabs.lib.ui.SuperRecyclerView;
import java.util.List;

public abstract class RecyclerListFragment<T, R extends RecyclerListAdapter<T, ?>>
extends BaseFragment {
    protected RecyclerView mRecyclerView;
    TextView mEmptyTextView;
    FrameLayout mEmptyLayout;
    protected SwipeRefreshLayout mSwipeRefreshLayout;
    protected SwipeRefreshLayout.OnRefreshListener mOnRefreshListener;
    protected R mAdapter;
    private RecyclerView.ItemAnimator mItemAnimator;
    private RecyclerView.LayoutManager mLayoutManager;

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        SuperRecyclerView superRecyclerView = (SuperRecyclerView)view.findViewWithTag((Object)"super_recycler_view_tag");
        if (superRecyclerView == null) {
            throw new InflateException("You must add <io.dflabs.lib.ui.SuperRecyclerView /> in your view");
        }
        this.mRecyclerView = superRecyclerView.getRecyclerView();
        this.mEmptyTextView = superRecyclerView.getEmptyTextView();
        this.mEmptyLayout = superRecyclerView.getEmptyLayout();
        this.mSwipeRefreshLayout = superRecyclerView.getSwipeToRefreshLayout();
        this.mOnRefreshListener = new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                RecyclerListFragment.this.refresh();
            }
        };
        this.mAdapter = this.getAdapter();
        this.mItemAnimator = this.getItemAnimator();
        this.mLayoutManager = this.getLayoutManager();
        this.mSwipeRefreshLayout.setOnRefreshListener(this.mOnRefreshListener);
        this.mRecyclerView.setLayoutManager(this.mLayoutManager);
        this.mRecyclerView.setItemAnimator(this.mItemAnimator);
        this.mRecyclerView.setAdapter(this.mAdapter);
        this.mRecyclerView.setHasFixedSize(true);
    }

    protected abstract void refresh();

    protected abstract RecyclerView.LayoutManager getLayoutManager();

    protected abstract RecyclerView.ItemAnimator getItemAnimator();

    protected abstract R getAdapter();

    protected void update(List<T> collection, boolean append) {
        this.mEmptyLayout.setVisibility(collection.size() == 0 ? 0 : 8);
        this.mRecyclerView.setVisibility(collection.size() > 0 ? 0 : 8);
        ((RecyclerListAdapter)((Object)this.mAdapter)).update(collection, append);
        this.mAdapter.notifyDataSetChanged();
    }

    public void startRefreshing() {
        this.mSwipeRefreshLayout.post(new Runnable(){

            @Override
            public void run() {
                RecyclerListFragment.this.mSwipeRefreshLayout.setRefreshing(true);
                RecyclerListFragment.this.mOnRefreshListener.onRefresh();
                RecyclerListFragment.this.stopRefreshing();
            }
        });
    }

    public void stopRefreshing() {
        this.mSwipeRefreshLayout.setRefreshing(false);
    }

    protected void setLayoutManager(RecyclerView.LayoutManager layoutManager) {
        this.mLayoutManager = layoutManager;
        this.mRecyclerView.setLayoutManager(layoutManager);
    }

    protected void setItemAnimator(RecyclerView.ItemAnimator itemAnimator) {
        this.mItemAnimator = itemAnimator;
        this.mRecyclerView.setItemAnimator(itemAnimator);
    }

    protected void setEmptyView(View v) {
        this.mEmptyLayout.removeAllViews();
        this.mEmptyLayout.addView(v);
    }

    protected void setEmptyText(int text) {
        this.mEmptyTextView.setText(text);
    }

    protected void setOnRefreshListener(SwipeRefreshLayout.OnRefreshListener onRefreshListener) {
        this.mOnRefreshListener = onRefreshListener;
        this.mOnRefreshListener = onRefreshListener;
    }

    protected void setAdapter(R adapter) {
        this.mAdapter = adapter;
        this.mRecyclerView.setAdapter(this.mAdapter);
    }
}

