/*
 * Decompiled with CFR 0.152.
 */
package io.dflabs.lib.validators;

import android.content.Context;
import java.util.ArrayList;

public class FormValidator {
    ArrayList<Validator> mValidators;
    private Context mContext;
    private boolean showAllErrors;

    public FormValidator(Context context) {
        this.mContext = context;
        this.mValidators = new ArrayList();
        this.showAllErrors = false;
    }

    public FormValidator(Context context, boolean showAllErrors) {
        this.mContext = context;
        this.showAllErrors = showAllErrors;
        this.mValidators = new ArrayList();
    }

    public <T extends Validator> void addValidator(T validator) {
        validator.setContext(this.mContext);
        this.mValidators.add(validator);
    }

    public <T extends Validator> void addValidators(Validator ... validators) {
        for (Validator validator : validators) {
            validator.setContext(this.mContext);
            this.mValidators.add(validator);
        }
    }

    public boolean isValid() {
        boolean valid = true;
        if (this.showAllErrors) {
            for (Validator v : this.mValidators) {
                if (!v.isValid()) {
                    v.showError();
                } else {
                    v.stopError();
                }
                valid &= v.isValid();
            }
        } else {
            for (Validator v : this.mValidators) {
                if (v.isValid()) continue;
                v.showError();
                valid = false;
                break;
            }
        }
        return valid;
    }

    public static abstract class Validator {
        Context context;

        public Validator(Context context) {
            this.context = context;
        }

        public Validator() {
        }

        public Context getContext() {
            return this.context;
        }

        public void setContext(Context context) {
            this.context = context;
        }

        abstract boolean isValid();

        abstract void showError();

        abstract void stopError();
    }
}

