/*
 * Decompiled with CFR 0.152.
 */
package io.dflabs.lib.utils;

import android.content.Context;
import com.google.gson.Gson;

public class Prefs {
    public static final String PREFS_NAME = "gnpPreferences";
    private static Prefs singleton;
    private Context context;

    public Prefs(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Prefs with(Context context) {
        if (singleton != null) return singleton;
        Class<Prefs> clazz = Prefs.class;
        synchronized (Prefs.class) {
            if (singleton != null) return singleton;
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null");
            }
            singleton = new Prefs(context);
            Prefs.singleton.context = context.getApplicationContext();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public int getInt(String key) {
        return this.context.getSharedPreferences(PREFS_NAME, 0).getInt(key, -1);
    }

    public int getInt(String key, int defaultValue) {
        return this.context.getSharedPreferences(PREFS_NAME, 0).getInt(key, defaultValue);
    }

    public String getString(String key) {
        return this.context.getSharedPreferences(PREFS_NAME, 0).getString(key, "");
    }

    public long getLong(String key) {
        return this.context.getSharedPreferences(PREFS_NAME, 0).getLong(key, -1L);
    }

    public Object getObject(String key, Class<?> fromClass) {
        try {
            String json = this.context.getSharedPreferences(PREFS_NAME, 0).getString(key, null);
            if (json != null) {
                Gson gson = new Gson();
                return gson.fromJson(json, fromClass);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void putInt(String key, int value) {
        this.context.getSharedPreferences(PREFS_NAME, 0).edit().putInt(key, value).commit();
    }

    public void putString(String key, String value) {
        this.context.getSharedPreferences(PREFS_NAME, 0).edit().putString(key, value).commit();
    }

    public void putLong(String key, long value) {
        this.context.getSharedPreferences(PREFS_NAME, 0).edit().putLong(key, value).commit();
    }

    public void putObject(String key, Object value, Class<?> fromClass) {
        try {
            Gson gson = new Gson();
            String json = gson.toJson(value, fromClass);
            this.context.getSharedPreferences(PREFS_NAME, 0).edit().putString(key, json).commit();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Only plain objects are supported");
        }
    }
}

