/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.exceptions.KernelException;
import io.delta.kernel.shaded.com.fasterxml.jackson.core.JsonFactory;
import io.delta.kernel.shaded.com.fasterxml.jackson.core.JsonGenerator;
import io.delta.kernel.shaded.com.fasterxml.jackson.core.type.TypeReference;
import io.delta.kernel.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Map;

public class JsonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final JsonFactory FACTORY = new JsonFactory();

    private JsonUtils() {
    }

    public static JsonFactory factory() {
        return FACTORY;
    }

    public static ObjectMapper mapper() {
        return MAPPER;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String generate(ToJson toJson) {
        try (StringWriter stringWriter = new StringWriter();){
            String string;
            block13: {
                JsonGenerator jsonGenerator = JsonUtils.factory().createGenerator(stringWriter);
                try {
                    toJson.generate(jsonGenerator);
                    jsonGenerator.flush();
                    string = stringWriter.toString();
                    if (jsonGenerator == null) break block13;
                }
                catch (Throwable throwable) {
                    if (jsonGenerator != null) {
                        try {
                            jsonGenerator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonGenerator.close();
            }
            return string;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static Map<String, String> parseJSONKeyValueMap(String string) {
        if (string == null || string.trim().isEmpty()) {
            return Collections.emptyMap();
        }
        try {
            return MAPPER.readValue(string, new TypeReference<Map<String, String>>(){});
        }
        catch (Exception exception) {
            throw new KernelException(String.format("Failed to parse JSON string: %s", string), exception);
        }
    }

    @FunctionalInterface
    public static interface ToJson {
        public void generate(JsonGenerator var1) throws IOException;
    }

    @FunctionalInterface
    public static interface JsonValueWriter<T> {
        public void write(JsonGenerator var1, T var2) throws IOException;
    }
}

