/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.skipping;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.expressions.And;
import io.delta.kernel.expressions.Column;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.expressions.Or;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.InternalScanFileUtils;
import io.delta.kernel.internal.skipping.DataSkippingPredicate;
import io.delta.kernel.internal.skipping.StatsSchemaHelper;
import io.delta.kernel.internal.util.ExpressionUtils;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;

public class DataSkippingUtils {
    private static final Map<String, String> REVERSE_COMPARATORS = new HashMap<String, String>(){
        {
            this.put("=", "=");
            this.put("<", ">");
            this.put("<=", ">=");
            this.put(">", "<");
            this.put(">=", "<=");
            this.put("IS NOT DISTINCT FROM", "IS NOT DISTINCT FROM");
        }
    };

    public static ColumnarBatch parseJsonStats(Engine engine, FilteredColumnarBatch filteredColumnarBatch, StructType structType) {
        ColumnVector columnVector = filteredColumnarBatch.getData().getColumnVector(InternalScanFileUtils.ADD_FILE_ORDINAL).getChild(InternalScanFileUtils.ADD_FILE_STATS_ORDINAL);
        return DeltaErrors.wrapEngineException(() -> engine.getJsonHandler().parseJson(columnVector, structType, filteredColumnarBatch.getSelectionVector()), "Parsing the JSON statistics with statsSchema=%s", structType);
    }

    public static StructType pruneStatsSchema(StructType structType, Set<Column> set) {
        return DataSkippingUtils.pruneSchema(set, structType, new String[0]);
    }

    public static Optional<DataSkippingPredicate> constructDataSkippingFilter(Predicate predicate, StructType structType) {
        StatsSchemaHelper statsSchemaHelper = new StatsSchemaHelper(structType);
        return DataSkippingUtils.constructDataSkippingFilter(predicate, statsSchemaHelper);
    }

    private static Optional<DataSkippingPredicate> constructDataSkippingFilter(Predicate predicate, StatsSchemaHelper statsSchemaHelper) {
        switch (predicate.getName().toUpperCase(Locale.ROOT)) {
            case "AND": {
                Optional<DataSkippingPredicate> optional = DataSkippingUtils.constructDataSkippingFilter(ExpressionUtils.asPredicate(ExpressionUtils.getLeft(predicate)), statsSchemaHelper);
                Optional<DataSkippingPredicate> optional2 = DataSkippingUtils.constructDataSkippingFilter(ExpressionUtils.asPredicate(ExpressionUtils.getRight(predicate)), statsSchemaHelper);
                if (optional.isPresent() && optional2.isPresent()) {
                    return Optional.of(new DataSkippingPredicate("AND", optional.get(), optional2.get()));
                }
                if (optional.isPresent()) {
                    return optional;
                }
                return optional2;
            }
            case "OR": {
                Optional<DataSkippingPredicate> optional = DataSkippingUtils.constructDataSkippingFilter(ExpressionUtils.asPredicate(ExpressionUtils.getLeft(predicate)), statsSchemaHelper);
                Optional<DataSkippingPredicate> optional3 = DataSkippingUtils.constructDataSkippingFilter(ExpressionUtils.asPredicate(ExpressionUtils.getRight(predicate)), statsSchemaHelper);
                if (optional.isPresent() && optional3.isPresent()) {
                    return Optional.of(new DataSkippingPredicate("OR", optional.get(), optional3.get()));
                }
                return Optional.empty();
            }
            case "IS_NOT_NULL": {
                Expression expression = ExpressionUtils.getUnaryChild(predicate);
                if (!(expression instanceof Column)) break;
                Column column = (Column)expression;
                if (!statsSchemaHelper.isSkippingEligibleNullCountColumn((Column)expression)) break;
                final Column column2 = statsSchemaHelper.getNullCountColumn(column);
                final Column column3 = statsSchemaHelper.getNumRecordsColumn();
                return Optional.of(new DataSkippingPredicate("<", Arrays.asList(column2, column3), (Set<Column>)new HashSet<Column>(){
                    {
                        this.add(column2);
                        this.add(column3);
                    }
                }));
            }
            case "IS_NULL": {
                Expression expression = ExpressionUtils.getUnaryChild(predicate);
                if (!(expression instanceof Column)) break;
                Column column = (Column)expression;
                if (!statsSchemaHelper.isSkippingEligibleNullCountColumn((Column)expression)) break;
                Column column4 = statsSchemaHelper.getNullCountColumn(column);
                Literal literal = Literal.ofLong(0L);
                return Optional.of(new DataSkippingPredicate(">", Arrays.asList(column4, literal), Collections.singleton(column4)));
            }
            case "=": 
            case "<": 
            case "<=": 
            case ">": 
            case ">=": 
            case "IS NOT DISTINCT FROM": {
                Expression expression = ExpressionUtils.getLeft(predicate);
                Expression expression2 = ExpressionUtils.getRight(predicate);
                if (expression instanceof Column && expression2 instanceof Literal) {
                    Column column = (Column)expression;
                    Literal literal = (Literal)expression2;
                    if (!statsSchemaHelper.isSkippingEligibleMinMaxColumn(column)) break;
                    if (!StatsSchemaHelper.isSkippingEligibleLiteral(literal)) break;
                    return DataSkippingUtils.constructComparatorDataSkippingFilters(predicate.getName(), column, literal, statsSchemaHelper);
                }
                if (!(expression2 instanceof Column) || !(expression instanceof Literal)) break;
                return DataSkippingUtils.constructDataSkippingFilter(DataSkippingUtils.reverseComparatorFilter(predicate), statsSchemaHelper);
            }
            case "NOT": {
                return DataSkippingUtils.constructNotDataSkippingFilters(ExpressionUtils.asPredicate(ExpressionUtils.getUnaryChild(predicate)), statsSchemaHelper);
            }
        }
        return Optional.empty();
    }

    private static Optional<DataSkippingPredicate> constructComparatorDataSkippingFilters(String string, Column column, Literal literal, StatsSchemaHelper statsSchemaHelper) {
        switch (string.toUpperCase(Locale.ROOT)) {
            case "=": {
                return Optional.of(new DataSkippingPredicate("AND", DataSkippingUtils.constructBinaryDataSkippingPredicate("<=", statsSchemaHelper.getMinColumn(column), literal), DataSkippingUtils.constructBinaryDataSkippingPredicate(">=", statsSchemaHelper.getMaxColumn(column), literal)));
            }
            case "<": {
                return Optional.of(DataSkippingUtils.constructBinaryDataSkippingPredicate("<", statsSchemaHelper.getMinColumn(column), literal));
            }
            case "<=": {
                return Optional.of(DataSkippingUtils.constructBinaryDataSkippingPredicate("<=", statsSchemaHelper.getMinColumn(column), literal));
            }
            case ">": {
                return Optional.of(DataSkippingUtils.constructBinaryDataSkippingPredicate(">", statsSchemaHelper.getMaxColumn(column), literal));
            }
            case ">=": {
                return Optional.of(DataSkippingUtils.constructBinaryDataSkippingPredicate(">=", statsSchemaHelper.getMaxColumn(column), literal));
            }
            case "IS NOT DISTINCT FROM": {
                return DataSkippingUtils.constructDataSkippingFilter(DataSkippingUtils.rewriteEqualNullSafe(column, literal), statsSchemaHelper);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported comparator expression %s", string));
    }

    private static DataSkippingPredicate constructBinaryDataSkippingPredicate(String string, Tuple2<Column, Optional<Expression>> tuple2, Literal literal) {
        Column column = (Column)tuple2._1;
        Column column2 = ((Optional)tuple2._2).isPresent() ? (Expression)((Optional)tuple2._2).get() : column;
        return new DataSkippingPredicate(string, Arrays.asList(column2, literal), Collections.singleton(column));
    }

    private static Predicate reverseComparatorFilter(Predicate predicate) {
        return new Predicate(REVERSE_COMPARATORS.get(predicate.getName().toUpperCase(Locale.ROOT)), ExpressionUtils.getRight(predicate), ExpressionUtils.getLeft(predicate));
    }

    private static Optional<DataSkippingPredicate> constructNotDataSkippingFilters(Predicate predicate, StatsSchemaHelper statsSchemaHelper) {
        switch (predicate.getName().toUpperCase(Locale.ROOT)) {
            case "AND": {
                return DataSkippingUtils.constructDataSkippingFilter((Predicate)new Or(new Predicate("NOT", ExpressionUtils.asPredicate(ExpressionUtils.getLeft(predicate))), new Predicate("NOT", ExpressionUtils.asPredicate(ExpressionUtils.getRight(predicate)))), statsSchemaHelper);
            }
            case "OR": {
                return DataSkippingUtils.constructDataSkippingFilter((Predicate)new And(new Predicate("NOT", ExpressionUtils.asPredicate(ExpressionUtils.getLeft(predicate))), new Predicate("NOT", ExpressionUtils.asPredicate(ExpressionUtils.getRight(predicate)))), statsSchemaHelper);
            }
            case "IS_NOT_NULL": {
                return DataSkippingUtils.constructDataSkippingFilter(new Predicate("IS_NULL", ExpressionUtils.getUnaryChild(predicate)), statsSchemaHelper);
            }
            case "IS_NULL": {
                return DataSkippingUtils.constructDataSkippingFilter(new Predicate("IS_NOT_NULL", ExpressionUtils.getUnaryChild(predicate)), statsSchemaHelper);
            }
            case "=": {
                return DataSkippingUtils.constructDataSkippingFiltersForNotEqual(predicate, statsSchemaHelper, (column, literal) -> Optional.of(new DataSkippingPredicate("OR", DataSkippingUtils.constructBinaryDataSkippingPredicate("<", statsSchemaHelper.getMinColumn((Column)column), literal), DataSkippingUtils.constructBinaryDataSkippingPredicate(">", statsSchemaHelper.getMaxColumn((Column)column), literal))));
            }
            case "<": {
                return DataSkippingUtils.constructDataSkippingFilter(new Predicate(">=", predicate.getChildren()), statsSchemaHelper);
            }
            case "<=": {
                return DataSkippingUtils.constructDataSkippingFilter(new Predicate(">", predicate.getChildren()), statsSchemaHelper);
            }
            case ">": {
                return DataSkippingUtils.constructDataSkippingFilter(new Predicate("<=", predicate.getChildren()), statsSchemaHelper);
            }
            case ">=": {
                return DataSkippingUtils.constructDataSkippingFilter(new Predicate("<", predicate.getChildren()), statsSchemaHelper);
            }
            case "IS NOT DISTINCT FROM": {
                return DataSkippingUtils.constructDataSkippingFiltersForNotEqual(predicate, statsSchemaHelper, (column, literal) -> DataSkippingUtils.constructDataSkippingFilter(new Predicate("NOT", DataSkippingUtils.rewriteEqualNullSafe(column, literal)), statsSchemaHelper));
            }
            case "NOT": {
                return DataSkippingUtils.constructDataSkippingFilter(ExpressionUtils.asPredicate(ExpressionUtils.getUnaryChild(predicate)), statsSchemaHelper);
            }
        }
        return Optional.empty();
    }

    private static StructType pruneSchema(Set<Column> set, StructType structType, String[] stringArray) {
        ArrayList<StructField> arrayList = new ArrayList<StructField>();
        for (StructField structField : structType.fields()) {
            String[] stringArray2 = DataSkippingUtils.appendArray(stringArray, structField.getName());
            if (structField.getDataType() instanceof StructType) {
                StructType structType2 = DataSkippingUtils.pruneSchema(set, (StructType)structField.getDataType(), stringArray2);
                if (structType2.length() <= 0) continue;
                arrayList.add(new StructField(structField.getName(), structType2, structField.isNullable(), structField.getMetadata()));
                continue;
            }
            if (!set.contains(new Column(stringArray2))) continue;
            arrayList.add(structField);
        }
        return new StructType(arrayList);
    }

    private static String[] appendArray(String[] stringArray, String string) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        return stringArray2;
    }

    private static Predicate rewriteEqualNullSafe(Column column, Literal literal) {
        if (literal.getValue() == null) {
            return new Predicate("IS_NULL", column);
        }
        return new Predicate("AND", new Predicate("IS_NOT_NULL", column), new Predicate("=", column, literal));
    }

    private static Optional<DataSkippingPredicate> constructDataSkippingFiltersForNotEqual(Predicate predicate, StatsSchemaHelper statsSchemaHelper, BiFunction<Column, Literal, Optional<DataSkippingPredicate>> biFunction) {
        Preconditions.checkArgument("=".equals(predicate.getName()) || "IS NOT DISTINCT FROM".equals(predicate.getName()), "Expects predicate to be = or IS NOT DISTINCT FROM");
        Expression expression = ExpressionUtils.getLeft(predicate);
        Expression expression2 = ExpressionUtils.getRight(predicate);
        if (expression2 instanceof Column && expression instanceof Literal) {
            return DataSkippingUtils.constructDataSkippingFilter(new Predicate("NOT", new Predicate(predicate.getName(), expression2, expression)), statsSchemaHelper);
        }
        if (expression instanceof Column && expression2 instanceof Literal) {
            Column column = (Column)expression;
            Literal literal = (Literal)expression2;
            if (statsSchemaHelper.isSkippingEligibleMinMaxColumn(column)) {
                if (StatsSchemaHelper.isSkippingEligibleLiteral(literal)) {
                    return biFunction.apply(column, literal);
                }
            }
        }
        return Optional.empty();
    }
}

