/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.rowtracking;

import io.delta.kernel.exceptions.InvalidTableException;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.util.ColumnMapping;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class MaterializedRowTrackingColumn {
    public static final MaterializedRowTrackingColumn ROW_ID = new MaterializedRowTrackingColumn(TableConfig.MATERIALIZED_ROW_ID_COLUMN_NAME, "_row-id-col-");
    public static final MaterializedRowTrackingColumn ROW_COMMIT_VERSION = new MaterializedRowTrackingColumn(TableConfig.MATERIALIZED_ROW_COMMIT_VERSION_COLUMN_NAME, "_row-commit-version-col-");
    private final TableConfig<String> tableConfig;
    private final String materializedColumnNamePrefix;

    private MaterializedRowTrackingColumn(TableConfig<String> tableConfig, String string) {
        this.tableConfig = tableConfig;
        this.materializedColumnNamePrefix = string;
    }

    public String getMaterializedColumnNameProperty() {
        return this.tableConfig.getKey();
    }

    public String getMaterializedColumnNamePrefix() {
        return this.materializedColumnNamePrefix;
    }

    public static void throwIfColumnNamesConflictWithSchema(Metadata metadata) {
        StructType structType = metadata.getSchema();
        Set set = structType.fields().stream().map(StructField::getName).collect(Collectors.toSet());
        Set set2 = structType.fields().stream().map(ColumnMapping::getPhysicalName).collect(Collectors.toSet());
        Stream.of(ROW_ID, ROW_COMMIT_VERSION).map(materializedRowTrackingColumn -> metadata.getConfiguration().get(materializedRowTrackingColumn.getMaterializedColumnNameProperty())).filter(Objects::nonNull).forEach(string -> {
            if (set.contains(string) || set2.contains(string)) {
                throw DeltaErrors.conflictWithReservedInternalColumnName(string);
            }
        });
    }

    public static void validateRowTrackingConfigsNotMissing(Metadata metadata, String string) {
        if (!TableConfig.ROW_TRACKING_ENABLED.fromMetadata(metadata).booleanValue()) {
            return;
        }
        Stream.of(ROW_ID, ROW_COMMIT_VERSION).forEach(materializedRowTrackingColumn -> {
            if (!metadata.getConfiguration().containsKey(materializedRowTrackingColumn.getMaterializedColumnNameProperty())) {
                throw new InvalidTableException(string, String.format("Row tracking is enabled but the materialized column name `%s` is missing.", materializedRowTrackingColumn.getMaterializedColumnNameProperty()));
            }
        });
    }

    public static Optional<Metadata> assignMaterializedColumnNamesIfNeeded(Metadata metadata) {
        if (!TableConfig.ROW_TRACKING_ENABLED.fromMetadata(metadata).booleanValue()) {
            return Optional.empty();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Stream.of(ROW_ID, ROW_COMMIT_VERSION).filter(materializedRowTrackingColumn -> !metadata.getConfiguration().containsKey(materializedRowTrackingColumn.getMaterializedColumnNameProperty())).forEach(materializedRowTrackingColumn -> hashMap.put(materializedRowTrackingColumn.getMaterializedColumnNameProperty(), materializedRowTrackingColumn.generateMaterializedColumnName()));
        return hashMap.isEmpty() ? Optional.empty() : Optional.of(metadata.withMergedConfiguration(hashMap));
    }

    private String generateMaterializedColumnName() {
        return this.materializedColumnNamePrefix + UUID.randomUUID().toString();
    }
}

