/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.replay;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.internal.actions.AddFile;
import io.delta.kernel.internal.actions.DeletionVectorDescriptor;
import io.delta.kernel.internal.actions.DomainMetadata;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.actions.SetTransaction;
import io.delta.kernel.internal.checkpoints.SidecarFile;
import io.delta.kernel.internal.checksum.CRCInfo;
import io.delta.kernel.internal.checksum.ChecksumReader;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.lang.Lazy;
import io.delta.kernel.internal.metrics.ScanMetrics;
import io.delta.kernel.internal.metrics.SnapshotMetrics;
import io.delta.kernel.internal.replay.ActionWrapper;
import io.delta.kernel.internal.replay.ActionsIterator;
import io.delta.kernel.internal.replay.ActiveAddFilesIterator;
import io.delta.kernel.internal.replay.LogReplayUtils;
import io.delta.kernel.internal.snapshot.LogSegment;
import io.delta.kernel.internal.snapshot.SnapshotHint;
import io.delta.kernel.internal.tablefeatures.TableFeatures;
import io.delta.kernel.internal.util.DomainMetadataUtils;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogReplay {
    private static final Logger logger = LoggerFactory.getLogger(LogReplay.class);
    public static final StructType PROTOCOL_METADATA_READ_SCHEMA = new StructType().add("protocol", Protocol.FULL_SCHEMA).add("metaData", Metadata.FULL_SCHEMA);
    private static StructType REMOVE_FILE_SCHEMA = new StructType().add("path", (DataType)StringType.STRING, false).add("deletionVector", (DataType)DeletionVectorDescriptor.READ_SCHEMA, true);
    public static final StructType SET_TRANSACTION_READ_SCHEMA = new StructType().add("txn", SetTransaction.FULL_SCHEMA);
    public static final StructType DOMAIN_METADATA_READ_SCHEMA = new StructType().add("domainMetadata", DomainMetadata.FULL_SCHEMA);
    public static String SIDECAR_FIELD_NAME = "sidecar";
    public static String ADDFILE_FIELD_NAME = "add";
    public static String REMOVEFILE_FIELD_NAME = "remove";
    public static int ADD_FILE_ORDINAL = 0;
    public static int ADD_FILE_PATH_ORDINAL = AddFile.SCHEMA_WITHOUT_STATS.indexOf("path");
    public static int ADD_FILE_DV_ORDINAL = AddFile.SCHEMA_WITHOUT_STATS.indexOf("deletionVector");
    public static int REMOVE_FILE_ORDINAL = 1;
    public static int REMOVE_FILE_PATH_ORDINAL = REMOVE_FILE_SCHEMA.indexOf("path");
    public static int REMOVE_FILE_DV_ORDINAL = REMOVE_FILE_SCHEMA.indexOf("deletionVector");
    private final Path dataPath;
    private final LogSegment logSegment;
    private final Tuple2<Protocol, Metadata> protocolAndMetadata;
    private final Lazy<Map<String, DomainMetadata>> activeDomainMetadataMap;
    private final CrcInfoContext crcInfoContext;
    private boolean readLogCompactionFiles = true;

    private static StructType getAddSchema(boolean bl) {
        return bl ? AddFile.SCHEMA_WITH_STATS : AddFile.SCHEMA_WITHOUT_STATS;
    }

    public static StructType withSidecarFileSchema(StructType structType) {
        return structType.add(SIDECAR_FIELD_NAME, SidecarFile.READ_SCHEMA);
    }

    public static boolean containsAddOrRemoveFileActions(StructType structType) {
        return structType.fieldNames().contains(ADDFILE_FIELD_NAME) || structType.fieldNames().contains(REMOVEFILE_FIELD_NAME);
    }

    public static StructType getAddRemoveReadSchema(boolean bl) {
        return new StructType().add(ADDFILE_FIELD_NAME, LogReplay.getAddSchema(bl)).add(REMOVEFILE_FIELD_NAME, REMOVE_FILE_SCHEMA);
    }

    public static StructType getAddReadSchema(boolean bl) {
        return new StructType().add(ADDFILE_FIELD_NAME, LogReplay.getAddSchema(bl));
    }

    public LogReplay(Path path, Path path2, Engine engine, LogSegment logSegment, Optional<SnapshotHint> optional, SnapshotMetrics snapshotMetrics) {
        LogReplayUtils.assertLogFilesBelongToTable(path, logSegment.allLogFilesUnsorted());
        if (optional.isPresent() && optional.get().getVersion() > logSegment.getVersion()) {
            optional = Optional.empty();
        }
        this.crcInfoContext = new CrcInfoContext(engine);
        this.dataPath = path2;
        this.logSegment = logSegment;
        Optional<SnapshotHint> optional2 = this.crcInfoContext.maybeGetNewerSnapshotHintAndUpdateCache(engine, logSegment, optional, logSegment.getVersion());
        this.protocolAndMetadata = snapshotMetrics.loadInitialDeltaActionsTimer.time(() -> {
            Tuple2<Protocol, Metadata> tuple2 = this.loadTableProtocolAndMetadata(engine, logSegment, optional2, logSegment.getVersion());
            TableFeatures.validateKernelCanReadTheTable((Protocol)tuple2._1, path2.toString());
            return tuple2;
        });
        this.activeDomainMetadataMap = new Lazy<Map>(() -> this.loadDomainMetadataMap(engine).entrySet().stream().filter(entry -> !((DomainMetadata)entry.getValue()).isRemoved()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public Protocol getProtocol() {
        return (Protocol)this.protocolAndMetadata._1;
    }

    public Metadata getMetadata() {
        return (Metadata)this.protocolAndMetadata._2;
    }

    public Optional<Long> getLatestTransactionIdentifier(Engine engine, String string) {
        return this.loadLatestTransactionVersion(engine, string);
    }

    public Map<String, DomainMetadata> getActiveDomainMetadataMap() {
        return this.activeDomainMetadataMap.get();
    }

    public long getVersion() {
        return this.logSegment.getVersion();
    }

    public Optional<CRCInfo> getCurrentCrcInfo() {
        return this.crcInfoContext.getLastSeenCrcInfo().filter(cRCInfo -> cRCInfo.getVersion() == this.getVersion());
    }

    public CloseableIterator<FilteredColumnarBatch> getAddFilesAsColumnarBatches(Engine engine, boolean bl, Optional<Predicate> optional, ScanMetrics scanMetrics) {
        ActionsIterator actionsIterator = new ActionsIterator(engine, this.getLogReplayFiles(this.logSegment), LogReplay.getAddRemoveReadSchema(bl), LogReplay.getAddReadSchema(bl), optional);
        return new ActiveAddFilesIterator(engine, actionsIterator, this.dataPath, scanMetrics);
    }

    private List<FileStatus> getLogReplayFiles(LogSegment logSegment) {
        if (this.readLogCompactionFiles) {
            return logSegment.allFilesWithCompactionsReversed();
        }
        return logSegment.allLogFilesReversed();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Tuple2<Protocol, Metadata> loadTableProtocolAndMetadata(Engine engine, LogSegment logSegment, Optional<SnapshotHint> optional, long l) {
        if (optional.isPresent() && optional.get().getVersion() == l) {
            return new Tuple2<Protocol, Metadata>(optional.get().getProtocol(), optional.get().getMetadata());
        }
        Protocol protocol = null;
        Metadata metadata = null;
        try (ActionsIterator actionsIterator = new ActionsIterator(engine, this.getLogReplayFiles(logSegment), PROTOCOL_METADATA_READ_SCHEMA, Optional.empty());){
            while (actionsIterator.hasNext()) {
                int n;
                Object object;
                ActionWrapper actionWrapper = (ActionWrapper)actionsIterator.next();
                long l2 = actionWrapper.getVersion();
                ColumnarBatch columnarBatch = null;
                if (protocol == null) {
                    columnarBatch = actionWrapper.getColumnarBatch();
                    assert (columnarBatch.getSchema().equals(PROTOCOL_METADATA_READ_SCHEMA));
                    object = columnarBatch.getColumnVector(0);
                    for (n = 0; n < object.getSize(); ++n) {
                        if (object.isNullAt(n)) continue;
                        protocol = Protocol.fromColumnVector((ColumnVector)object, n);
                        if (metadata == null) break;
                        Tuple2<Protocol, Metadata> tuple2 = new Tuple2<Protocol, Metadata>(protocol, metadata);
                        return tuple2;
                    }
                }
                if (metadata == null) {
                    if (columnarBatch == null) {
                        columnarBatch = actionWrapper.getColumnarBatch();
                        assert (columnarBatch.getSchema().equals(PROTOCOL_METADATA_READ_SCHEMA));
                    }
                    object = columnarBatch.getColumnVector(1);
                    for (n = 0; n < object.getSize(); ++n) {
                        if (object.isNullAt(n)) continue;
                        metadata = Metadata.fromColumnVector((ColumnVector)object, n);
                        if (protocol == null) break;
                        Tuple2<Protocol, Metadata> tuple2 = new Tuple2<Protocol, Metadata>(protocol, metadata);
                        return tuple2;
                    }
                }
                if (!optional.isPresent() || l2 != optional.get().getVersion() + 1L) continue;
                if (protocol == null) {
                    protocol = optional.get().getProtocol();
                }
                if (metadata == null) {
                    metadata = optional.get().getMetadata();
                }
                object = new Tuple2<Protocol, Metadata>(protocol, metadata);
                return object;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not close iterator", iOException);
        }
        if (protocol == null) {
            throw new IllegalStateException(String.format("No protocol found at version %s", logSegment.getVersion()));
        }
        throw new IllegalStateException(String.format("No metadata found at version %s", logSegment.getVersion()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Long> loadLatestTransactionVersion(Engine engine, String string) {
        try (ActionsIterator actionsIterator = new ActionsIterator(engine, this.getLogReplayFiles(this.logSegment), SET_TRANSACTION_READ_SCHEMA, Optional.empty());){
            block8: while (true) {
                if (!actionsIterator.hasNext()) return Optional.empty();
                ColumnarBatch columnarBatch = ((ActionWrapper)actionsIterator.next()).getColumnarBatch();
                assert (columnarBatch.getSchema().equals(SET_TRANSACTION_READ_SCHEMA));
                ColumnVector columnVector = columnarBatch.getColumnVector(0);
                int n = 0;
                while (true) {
                    SetTransaction setTransaction;
                    if (n >= columnVector.getSize()) continue block8;
                    if (!columnVector.isNullAt(n) && (setTransaction = SetTransaction.fromColumnVector(columnVector, n)) != null && string.equals(setTransaction.getAppId())) {
                        Optional<Long> optional = Optional.of(setTransaction.getVersion());
                        return optional;
                    }
                    ++n;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to fetch the transaction identifier", iOException);
        }
    }

    private Map<String, DomainMetadata> loadDomainMetadataMap(Engine engine) {
        Optional<CRCInfo> optional = this.crcInfoContext.getLastSeenCrcInfo();
        if (!optional.isPresent() || !optional.get().getDomainMetadata().isPresent()) {
            logger.info("No domain metadata available in CRC info, loading from log");
            return this.loadDomainMetadataMapFromLog(engine, Optional.empty());
        }
        CRCInfo cRCInfo = optional.get();
        if (cRCInfo.getVersion() == this.logSegment.getVersion()) {
            return cRCInfo.getDomainMetadata().get().stream().collect(Collectors.toMap(DomainMetadata::getDomain, Function.identity()));
        }
        Map<String, DomainMetadata> map = this.loadDomainMetadataMapFromLog(engine, Optional.of(cRCInfo.getVersion() + 1L));
        cRCInfo.getDomainMetadata().get().forEach(domainMetadata -> {
            if (!map.containsKey(domainMetadata.getDomain())) {
                map.put(domainMetadata.getDomain(), (DomainMetadata)domainMetadata);
            }
        });
        return map;
    }

    private Map<String, DomainMetadata> loadDomainMetadataMapFromLog(Engine engine, Optional<Long> optional) {
        Object object;
        ActionsIterator actionsIterator = new ActionsIterator(engine, this.getLogReplayFiles(this.logSegment), DOMAIN_METADATA_READ_SCHEMA, Optional.empty());
        try {
            HashMap<String, DomainMetadata> hashMap = new HashMap<String, DomainMetadata>();
            while (actionsIterator.hasNext()) {
                object = (ActionWrapper)actionsIterator.next();
                long l = ((ActionWrapper)object).getVersion();
                ColumnarBatch columnarBatch = ((ActionWrapper)object).getColumnarBatch();
                assert (columnarBatch.getSchema().equals(DOMAIN_METADATA_READ_SCHEMA));
                ColumnVector columnVector = columnarBatch.getColumnVector(0);
                DomainMetadataUtils.populateDomainMetadataMap(columnVector, hashMap);
                if (!optional.isPresent() || optional.get() != l) continue;
                break;
            }
            object = hashMap;
        }
        catch (Throwable throwable) {
            try {
                try {
                    actionsIterator.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new UncheckedIOException("Could not close iterator", iOException);
            }
        }
        actionsIterator.close();
        return object;
    }

    private class CrcInfoContext {
        private final Engine engine;
        private Optional<CRCInfo> cachedLastSeenCrcInfo;

        CrcInfoContext(Engine engine) {
            this.engine = Objects.requireNonNull(engine);
            this.cachedLastSeenCrcInfo = Optional.empty();
        }

        public Optional<CRCInfo> getLastSeenCrcInfo() {
            if (!this.cachedLastSeenCrcInfo.isPresent()) {
                this.cachedLastSeenCrcInfo = LogReplay.this.logSegment.getLastSeenChecksum().flatMap(fileStatus -> ChecksumReader.getCRCInfo(this.engine, fileStatus));
            }
            return this.cachedLastSeenCrcInfo;
        }

        public Optional<SnapshotHint> maybeGetNewerSnapshotHintAndUpdateCache(Engine engine, LogSegment logSegment, Optional<SnapshotHint> optional, long l) {
            if (optional.isPresent() && optional.get().getVersion() == l) {
                return optional;
            }
            long l2 = optional.map(SnapshotHint::getVersion).orElse(-1L) + 1L;
            Optional optional2 = logSegment.getLastSeenChecksum().filter(fileStatus -> FileNames.getFileVersion(new Path(fileStatus.getPath())) >= l2).flatMap(fileStatus -> ChecksumReader.getCRCInfo(engine, fileStatus));
            if (!optional2.isPresent()) {
                return optional;
            }
            CRCInfo cRCInfo = (CRCInfo)optional2.get();
            this.cachedLastSeenCrcInfo = Optional.of(cRCInfo);
            Preconditions.checkArgument(cRCInfo.getVersion() >= l2 && cRCInfo.getVersion() <= l);
            return Optional.of(SnapshotHint.fromCrcInfo(cRCInfo));
        }
    }
}

