/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.replay;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.expressions.Column;
import io.delta.kernel.expressions.Or;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.checkpoints.SidecarFile;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.replay.ActionWrapper;
import io.delta.kernel.internal.replay.DeltaLogFile;
import io.delta.kernel.internal.replay.LogReplay;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.InCommitTimestampUtils;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;

public class ActionsIterator
implements CloseableIterator<ActionWrapper> {
    private final Engine engine;
    private final Optional<Predicate> checkpointPredicate;
    private final LinkedList<DeltaLogFile> filesList;
    private final StructType deltaReadSchema;
    private final StructType checkpointReadSchema;
    private final boolean schemaContainsAddOrRemoveFiles;
    private Optional<CloseableIterator<ActionWrapper>> actionsIter;
    private boolean closed;

    public ActionsIterator(Engine engine, List<FileStatus> list, StructType structType, Optional<Predicate> optional) {
        this(engine, list, structType, structType, optional);
    }

    public ActionsIterator(Engine engine, List<FileStatus> list, StructType structType, StructType structType2, Optional<Predicate> optional) {
        this.engine = engine;
        this.checkpointPredicate = optional;
        this.filesList = new LinkedList();
        this.filesList.addAll(list.stream().map(DeltaLogFile::forFileStatus).collect(Collectors.toList()));
        this.deltaReadSchema = structType;
        this.checkpointReadSchema = structType2;
        this.actionsIter = Optional.empty();
        this.schemaContainsAddOrRemoveFiles = LogReplay.containsAddOrRemoveFileActions(structType);
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            throw new IllegalStateException("Can't call `hasNext` on a closed iterator.");
        }
        this.tryEnsureNextActionsIterIsReady();
        return this.actionsIter.isPresent();
    }

    @Override
    public ActionWrapper next() {
        if (this.closed) {
            throw new IllegalStateException("Can't call `next` on a closed iterator.");
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        return this.actionsIter.get().next();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed && this.actionsIter.isPresent()) {
            this.actionsIter.get().close();
            this.actionsIter = Optional.empty();
            this.closed = true;
        }
    }

    private void tryEnsureNextActionsIterIsReady() {
        if (this.actionsIter.isPresent()) {
            if (this.actionsIter.get().hasNext()) {
                return;
            }
            Utils.closeCloseables(this.actionsIter.get());
            this.actionsIter = Optional.empty();
        }
        while (!this.filesList.isEmpty()) {
            this.actionsIter = Optional.of(this.getNextActionsIter());
            if (this.actionsIter.get().hasNext()) {
                return;
            }
            Utils.closeCloseables(this.actionsIter.get());
            this.actionsIter = Optional.empty();
        }
    }

    private CloseableIterator<ColumnarBatch> getActionsIterFromSinglePartOrV2Checkpoint(FileStatus fileStatus, String string) throws IOException {
        Optional<Predicate> optional;
        Object object;
        StructType structType = this.checkpointReadSchema;
        if (this.schemaContainsAddOrRemoveFiles) {
            structType = LogReplay.withSidecarFileSchema(this.checkpointReadSchema);
        }
        long l = FileNames.checkpointVersion(fileStatus.getPath());
        if (this.schemaContainsAddOrRemoveFiles) {
            object = new Predicate("IS_NOT_NULL", new Column(LogReplay.SIDECAR_FIELD_NAME));
            optional = this.checkpointPredicate.map(arg_0 -> ActionsIterator.lambda$getActionsIterFromSinglePartOrV2Checkpoint$0((Predicate)object, arg_0));
        } else {
            optional = this.checkpointPredicate;
        }
        StructType structType2 = structType;
        if (string.endsWith(".parquet")) {
            object = DeltaErrors.wrapEngineExceptionThrowsIO(() -> this.engine.getParquetHandler().readParquetFiles(Utils.singletonCloseableIterator(fileStatus), structType2, optional), "Reading parquet log file `%s` with readSchema=%s and predicate=%s", fileStatus, structType2, optional);
        } else if (string.endsWith(".json")) {
            object = DeltaErrors.wrapEngineExceptionThrowsIO(() -> this.engine.getJsonHandler().readJsonFiles(Utils.singletonCloseableIterator(fileStatus), structType2, optional), "Reading JSON log file `%s` with readSchema=%s and predicate=%s", fileStatus, structType2, optional);
        } else {
            throw new IOException("Unrecognized top level v2 checkpoint file format: " + string);
        }
        return new CloseableIterator<ColumnarBatch>(){
            final /* synthetic */ CloseableIterator val$topLevelIter;
            final /* synthetic */ FileStatus val$file;
            final /* synthetic */ long val$checkpointVersion;
            {
                this.val$topLevelIter = closeableIterator;
                this.val$file = fileStatus;
                this.val$checkpointVersion = l;
            }

            @Override
            public void close() throws IOException {
                this.val$topLevelIter.close();
            }

            @Override
            public boolean hasNext() {
                return this.val$topLevelIter.hasNext();
            }

            @Override
            public ColumnarBatch next() {
                ColumnarBatch columnarBatch = (ColumnarBatch)this.val$topLevelIter.next();
                if (ActionsIterator.this.schemaContainsAddOrRemoveFiles) {
                    return ActionsIterator.this.extractSidecarsFromBatch(this.val$file, this.val$checkpointVersion, columnarBatch);
                }
                return columnarBatch;
            }
        };
    }

    public ColumnarBatch extractSidecarsFromBatch(FileStatus fileStatus, long l, ColumnarBatch columnarBatch) {
        Preconditions.checkArgument(columnarBatch.getSchema().fieldNames().contains(LogReplay.SIDECAR_FIELD_NAME));
        Path path = new Path(fileStatus.getPath()).getParent();
        ArrayList arrayList = new ArrayList();
        int n = columnarBatch.getSchema().fieldNames().indexOf(LogReplay.SIDECAR_FIELD_NAME);
        ColumnVector columnVector = columnarBatch.getColumnVector(n);
        for (int i = 0; i < columnarBatch.getSize(); ++i) {
            SidecarFile sidecarFile = SidecarFile.fromColumnVector(columnVector, i);
            if (sidecarFile == null) continue;
            FileStatus fileStatus2 = FileStatus.of(FileNames.sidecarFile(path, sidecarFile.getPath()), sidecarFile.getSizeInBytes(), sidecarFile.getModificationTime());
            this.filesList.add(DeltaLogFile.ofSideCar(fileStatus2, l));
        }
        return columnarBatch.withDeletedColumnAt(n);
    }

    private CloseableIterator<ActionWrapper> getNextActionsIter() {
        DeltaLogFile deltaLogFile = this.filesList.pop();
        FileStatus fileStatus = deltaLogFile.getFile();
        Path path = new Path(fileStatus.getPath());
        String string = path.getName();
        try {
            switch (deltaLogFile.getLogType()) {
                case COMMIT: {
                    long l = FileNames.deltaVersion(path);
                    return this.readCommitOrCompactionFile(l, fileStatus);
                }
                case LOG_COMPACTION: {
                    long l = (Long)FileNames.logCompactionVersions((Path)path)._2;
                    return this.readCommitOrCompactionFile(l, fileStatus);
                }
                case CHECKPOINT_CLASSIC: 
                case V2_CHECKPOINT_MANIFEST: {
                    CloseableIterator<ColumnarBatch> closeableIterator = this.getActionsIterFromSinglePartOrV2Checkpoint(fileStatus, string);
                    long l = FileNames.checkpointVersion(path);
                    return this.combine(closeableIterator, true, l, Optional.empty());
                }
                case MULTIPART_CHECKPOINT: 
                case SIDECAR: {
                    CloseableIterator<FileStatus> closeableIterator = this.retrieveRemainingCheckpointFiles(deltaLogFile);
                    CloseableIterator closeableIterator2 = DeltaErrors.wrapEngineExceptionThrowsIO(() -> this.engine.getParquetHandler().readParquetFiles(closeableIterator, this.deltaReadSchema, this.checkpointPredicate), "Reading checkpoint sidecars [%s] with readSchema=%s and predicate=%s", closeableIterator, this.deltaReadSchema, this.checkpointPredicate);
                    long l = FileNames.checkpointVersion(path);
                    return this.combine(closeableIterator2, true, l, Optional.empty());
                }
            }
            throw new IOException("Unrecognized log type: " + (Object)((Object)deltaLogFile.getLogType()));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private CloseableIterator<ActionWrapper> readCommitOrCompactionFile(long l, FileStatus fileStatus) throws IOException {
        CloseableIterator closeableIterator = DeltaErrors.wrapEngineExceptionThrowsIO(() -> this.engine.getJsonHandler().readJsonFiles(Utils.singletonCloseableIterator(fileStatus), this.deltaReadSchema, Optional.empty()), "Reading JSON log file `%s` with readSchema=%s", fileStatus, this.deltaReadSchema);
        return this.combine(closeableIterator, false, l, Optional.of(fileStatus.getModificationTime()));
    }

    private CloseableIterator<ActionWrapper> combine(CloseableIterator<ColumnarBatch> closeableIterator, final boolean bl, final long l, Optional<Long> optional) {
        CloseableIterator<ColumnarBatch> closeableIterator2;
        Object object;
        Optional<Object> optional2 = Optional.empty();
        if (!bl && closeableIterator.hasNext()) {
            object = closeableIterator.next();
            closeableIterator2 = Utils.singletonCloseableIterator(object).combine(closeableIterator);
            optional2 = InCommitTimestampUtils.tryExtractInCommitTimestamp((ColumnarBatch)object);
        } else {
            closeableIterator2 = closeableIterator;
        }
        object = optional2.isPresent() ? optional2 : optional;
        return new CloseableIterator<ActionWrapper>(){
            final /* synthetic */ Optional val$finalResolvedCommitTimestamp;
            final /* synthetic */ CloseableIterator val$fileReadDataIter;
            {
                this.val$finalResolvedCommitTimestamp = optional;
                this.val$fileReadDataIter = closeableIterator22;
            }

            @Override
            public boolean hasNext() {
                return closeableIterator2.hasNext();
            }

            @Override
            public ActionWrapper next() {
                return new ActionWrapper((ColumnarBatch)closeableIterator2.next(), bl, l, this.val$finalResolvedCommitTimestamp);
            }

            @Override
            public void close() throws IOException {
                this.val$fileReadDataIter.close();
            }
        };
    }

    private CloseableIterator<FileStatus> retrieveRemainingCheckpointFiles(DeltaLogFile deltaLogFile) {
        ArrayList<FileStatus> arrayList = new ArrayList<FileStatus>();
        arrayList.add(deltaLogFile.getFile());
        if (deltaLogFile.getLogType() == DeltaLogFile.LogType.SIDECAR || deltaLogFile.getLogType() == DeltaLogFile.LogType.MULTIPART_CHECKPOINT) {
            DeltaLogFile deltaLogFile2 = this.filesList.peek();
            while (deltaLogFile2 != null && deltaLogFile.getLogType() == deltaLogFile2.getLogType() && deltaLogFile.getVersion() == deltaLogFile2.getVersion()) {
                arrayList.add(this.filesList.pop().getFile());
                deltaLogFile2 = this.filesList.peek();
            }
        }
        return Utils.toCloseableIterator(arrayList.iterator());
    }

    private static /* synthetic */ Predicate lambda$getActionsIterFromSinglePartOrV2Checkpoint$0(Predicate predicate, Predicate predicate2) {
        return new Or(predicate2, predicate);
    }
}

