/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.metrics;

import io.delta.kernel.internal.metrics.DeltaOperationReportImpl;
import io.delta.kernel.internal.metrics.TransactionMetrics;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.metrics.SnapshotReport;
import io.delta.kernel.metrics.TransactionMetricsResult;
import io.delta.kernel.metrics.TransactionReport;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class TransactionReportImpl
extends DeltaOperationReportImpl
implements TransactionReport {
    private final String operation;
    private final String engineInfo;
    private final long snapshotVersion;
    private final Optional<UUID> snapshotReportUUID;
    private final Optional<Long> committedVersion;
    private final TransactionMetricsResult transactionMetrics;

    public TransactionReportImpl(String string, String string2, String string3, Optional<Long> optional, TransactionMetrics transactionMetrics, SnapshotReport snapshotReport, Optional<Exception> optional2) {
        super(string, optional2);
        this.operation = Objects.requireNonNull(string2);
        this.engineInfo = Objects.requireNonNull(string3);
        this.transactionMetrics = Objects.requireNonNull(transactionMetrics).captureTransactionMetricsResult();
        this.committedVersion = optional;
        Objects.requireNonNull(snapshotReport);
        Preconditions.checkArgument(!snapshotReport.getException().isPresent(), "Expected a successful SnapshotReport provided report has exception");
        Preconditions.checkArgument(snapshotReport.getVersion().isPresent(), "Expected a successful SnapshotReport but missing version");
        this.snapshotVersion = Objects.requireNonNull(snapshotReport).getVersion().get();
        this.snapshotReportUUID = this.snapshotVersion < 0L ? Optional.empty() : Optional.of(snapshotReport.getReportUUID());
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    @Override
    public String getEngineInfo() {
        return this.engineInfo;
    }

    @Override
    public long getBaseSnapshotVersion() {
        return this.snapshotVersion;
    }

    @Override
    public Optional<UUID> getSnapshotReportUUID() {
        return this.snapshotReportUUID;
    }

    @Override
    public Optional<Long> getCommittedVersion() {
        return this.committedVersion;
    }

    @Override
    public TransactionMetricsResult getTransactionMetrics() {
        return this.transactionMetrics;
    }
}

