/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.files;

import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.internal.files.ParsedCheckpointData;
import io.delta.kernel.internal.files.ParsedLogData;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.utils.FileStatus;
import java.util.Objects;
import java.util.Optional;

public class ParsedMultiPartCheckpointData
extends ParsedCheckpointData {
    public final int part;
    public final int numParts;

    public static ParsedMultiPartCheckpointData forFileStatus(FileStatus fileStatus) {
        long l = FileNames.checkpointVersion(fileStatus.getPath());
        Tuple2<Integer, Integer> tuple2 = FileNames.multiPartCheckpointPartAndNumParts(fileStatus.getPath());
        return new ParsedMultiPartCheckpointData(l, (Integer)tuple2._1, (Integer)tuple2._2, Optional.of(fileStatus), Optional.empty());
    }

    public static ParsedMultiPartCheckpointData forInlineData(long l, int n, int n2, ColumnarBatch columnarBatch) {
        return new ParsedMultiPartCheckpointData(l, n, n2, Optional.empty(), Optional.of(columnarBatch));
    }

    private ParsedMultiPartCheckpointData(long l, int n, int n2, Optional<FileStatus> optional, Optional<ColumnarBatch> optional2) {
        super(l, ParsedLogData.ParsedLogType.MULTIPART_CHECKPOINT, optional, optional2);
        Preconditions.checkArgument(n2 > 0, "numParts must be greater than 0");
        Preconditions.checkArgument(n > 0 && n <= n2, "part must be between 1 and numParts");
        this.part = n;
        this.numParts = n2;
    }

    @Override
    protected void appendAdditionalToStringFields(StringBuilder stringBuilder) {
        stringBuilder.append(", part=").append(this.part).append(", numParts=").append(this.numParts);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ParsedMultiPartCheckpointData parsedMultiPartCheckpointData = (ParsedMultiPartCheckpointData)object;
        return this.part == parsedMultiPartCheckpointData.part && this.numParts == parsedMultiPartCheckpointData.numParts;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.part, this.numParts);
    }
}

