/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.files;

import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.internal.files.ParsedLogData;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.utils.FileStatus;
import java.util.Objects;
import java.util.Optional;

public class ParsedLogCompactionData
extends ParsedLogData {
    public final long startVersion;
    public final long endVersion;

    public static ParsedLogCompactionData forFileStatus(FileStatus fileStatus) {
        Tuple2<Long, Long> tuple2 = FileNames.logCompactionVersions(fileStatus.getPath());
        return new ParsedLogCompactionData((long)((Long)tuple2._1), (Long)tuple2._2, Optional.of(fileStatus), Optional.empty());
    }

    public static ParsedLogCompactionData forInlineData(int n, int n2, ColumnarBatch columnarBatch) {
        return new ParsedLogCompactionData((long)n, n2, Optional.empty(), Optional.of(columnarBatch));
    }

    private ParsedLogCompactionData(long l, long l2, Optional<FileStatus> optional, Optional<ColumnarBatch> optional2) {
        super(l2, ParsedLogData.ParsedLogType.LOG_COMPACTION, optional, optional2);
        Preconditions.checkArgument(l >= 0L && l2 >= 0L, "startVersion and endVersion must be non-negative");
        Preconditions.checkArgument(l < l2, "startVersion must be less than endVersion");
        this.startVersion = l;
        this.endVersion = l2;
    }

    @Override
    protected void appendAdditionalToStringFields(StringBuilder stringBuilder) {
        stringBuilder.append(", startVersion=").append(this.startVersion);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ParsedLogCompactionData parsedLogCompactionData = (ParsedLogCompactionData)object;
        return this.startVersion == parsedLogCompactionData.startVersion && this.endVersion == parsedLogCompactionData.endVersion;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.startVersion, this.endVersion);
    }
}

