/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.data;

import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.data.Row;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;

public class GenericRow
implements Row {
    private final StructType schema;
    private final Map<Integer, Object> ordinalToValue;

    public GenericRow(StructType structType, Map<Integer, Object> map) {
        this.schema = Objects.requireNonNull(structType, "schema is null");
        this.ordinalToValue = Objects.requireNonNull(map, "ordinalToValue is null");
    }

    @Override
    public StructType getSchema() {
        return this.schema;
    }

    @Override
    public boolean isNullAt(int n) {
        return this.getValue(n) == null;
    }

    @Override
    public boolean getBoolean(int n) {
        this.throwIfUnsafeAccess(n, BooleanType.class, "boolean");
        return (Boolean)this.getValue(n);
    }

    @Override
    public byte getByte(int n) {
        this.throwIfUnsafeAccess(n, ByteType.class, "byte");
        return (Byte)this.getValue(n);
    }

    @Override
    public short getShort(int n) {
        this.throwIfUnsafeAccess(n, ShortType.class, "short");
        return (Short)this.getValue(n);
    }

    @Override
    public int getInt(int n) {
        this.throwIfUnsafeAccess(n, IntegerType.class, "integer");
        return (Integer)this.getValue(n);
    }

    @Override
    public long getLong(int n) {
        this.throwIfUnsafeAccess(n, LongType.class, "long");
        return (Long)this.getValue(n);
    }

    @Override
    public float getFloat(int n) {
        this.throwIfUnsafeAccess(n, FloatType.class, "float");
        return ((Float)this.getValue(n)).floatValue();
    }

    @Override
    public double getDouble(int n) {
        this.throwIfUnsafeAccess(n, DoubleType.class, "double");
        return (Double)this.getValue(n);
    }

    @Override
    public String getString(int n) {
        this.throwIfUnsafeAccess(n, StringType.class, "string");
        return (String)this.getValue(n);
    }

    @Override
    public BigDecimal getDecimal(int n) {
        this.throwIfUnsafeAccess(n, DecimalType.class, "decimal");
        return (BigDecimal)this.getValue(n);
    }

    @Override
    public byte[] getBinary(int n) {
        this.throwIfUnsafeAccess(n, BinaryType.class, "binary");
        return (byte[])this.getValue(n);
    }

    @Override
    public Row getStruct(int n) {
        this.throwIfUnsafeAccess(n, StructType.class, "struct");
        return (Row)this.getValue(n);
    }

    @Override
    public ArrayValue getArray(int n) {
        this.throwIfUnsafeAccess(n, ArrayType.class, "array");
        return (ArrayValue)this.getValue(n);
    }

    @Override
    public MapValue getMap(int n) {
        this.throwIfUnsafeAccess(n, MapType.class, "map");
        return (MapValue)this.getValue(n);
    }

    private Object getValue(int n) {
        return this.ordinalToValue.get(n);
    }

    private void throwIfUnsafeAccess(int n, Class<? extends DataType> clazz, String string) {
        DataType dataType = this.dataType(n);
        if (!clazz.isAssignableFrom(dataType.getClass())) {
            String string2 = String.format("Trying to access a `%s` value from vector of type `%s`", string, dataType);
            throw new UnsupportedOperationException(string2);
        }
    }

    private DataType dataType(int n) {
        if (this.schema.length() <= n) {
            throw new IllegalArgumentException("invalid ordinal: " + n);
        }
        return this.schema.at(n).getDataType();
    }
}

