/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.data.GenericRow;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Format {
    public static final StructType FULL_SCHEMA = new StructType().add("provider", (DataType)StringType.STRING, false).add("options", (DataType)new MapType(StringType.STRING, StringType.STRING, false), true);
    private final String provider;
    private final Map<String, String> options;

    public static Format fromColumnVector(ColumnVector columnVector, int n) {
        if (columnVector.isNullAt(n)) {
            return null;
        }
        String string = InternalUtils.requireNonNull(columnVector.getChild(0), n, "provider").getString(n);
        Map<String, String> map = columnVector.getChild(1).isNullAt(n) ? Collections.emptyMap() : VectorUtils.toJavaMap(columnVector.getChild(1).getMap(n));
        return new Format(string, map);
    }

    public Format(String string, Map<String, String> map) {
        this.provider = string;
        this.options = map;
    }

    public Format() {
        this.provider = "parquet";
        this.options = Collections.emptyMap();
    }

    public String getProvider() {
        return this.provider;
    }

    public Map<String, String> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    public Row toRow() {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(0, this.provider);
        hashMap.put(1, VectorUtils.stringStringMapValue(this.options));
        return new GenericRow(FULL_SCHEMA, hashMap);
    }

    public String toString() {
        return "Format{provider='" + this.provider + '\'' + ", options=" + this.options + '}';
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Format format = (Format)object;
        return this.provider.equals(format.provider) && this.options.equals(format.options);
    }

    public int hashCode() {
        return Objects.hash(this.provider, this.options);
    }
}

