/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.data.MapValue;
import io.delta.kernel.data.Row;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.internal.actions.DeletionVectorDescriptor;
import io.delta.kernel.internal.actions.RemoveFile;
import io.delta.kernel.internal.actions.RowBackedAction;
import io.delta.kernel.internal.data.GenericRow;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.internal.util.PartitionUtils;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.StatsUtils;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.statistics.DataFileStatistics;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.DataFileStatus;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AddFile
extends RowBackedAction {
    private static final StructField JSON_STATS_FIELD = new StructField("stats", StringType.STRING, true);
    public static final StructType SCHEMA_WITHOUT_STATS = new StructType().add("path", (DataType)StringType.STRING, false).add("partitionValues", (DataType)new MapType(StringType.STRING, StringType.STRING, true), false).add("size", (DataType)LongType.LONG, false).add("modificationTime", (DataType)LongType.LONG, false).add("dataChange", (DataType)BooleanType.BOOLEAN, false).add("deletionVector", (DataType)DeletionVectorDescriptor.READ_SCHEMA, true).add("tags", (DataType)new MapType(StringType.STRING, StringType.STRING, true), true).add("baseRowId", (DataType)LongType.LONG, true).add("defaultRowCommitVersion", (DataType)LongType.LONG, true);
    public static final StructType SCHEMA_WITH_STATS;
    public static final StructType FULL_SCHEMA;

    public static AddFile convertDataFileStatus(StructType structType, URI uRI, DataFileStatus dataFileStatus, Map<String, Literal> map, boolean bl, Map<String, String> map2) {
        Optional<MapValue> optional = !map2.isEmpty() ? Optional.of(VectorUtils.stringStringMapValue(map2)) : Optional.empty();
        Row row = AddFile.createAddFileRow(structType, InternalUtils.relativizePath(new Path(dataFileStatus.getPath()), uRI).toUri().toString(), PartitionUtils.serializePartitionMap(map), dataFileStatus.getSize(), dataFileStatus.getModificationTime(), bl, Optional.empty(), optional, Optional.empty(), Optional.empty(), dataFileStatus.getStatistics());
        return new AddFile(row);
    }

    public static Row createAddFileRow(StructType structType, String string, MapValue mapValue2, long l2, long l3, boolean bl, Optional<DeletionVectorDescriptor> optional, Optional<MapValue> optional2, Optional<Long> optional3, Optional<Long> optional4, Optional<DataFileStatistics> optional5) {
        Preconditions.checkArgument(string != null, "path is not nullable");
        Preconditions.checkArgument(mapValue2 != null, "partitionValues is not nullable");
        Preconditions.checkArgument(!optional.isPresent(), "DeletionVectorDescriptor is unsupported");
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(FULL_SCHEMA.indexOf("path"), string);
        hashMap.put(FULL_SCHEMA.indexOf("partitionValues"), mapValue2);
        hashMap.put(FULL_SCHEMA.indexOf("size"), l2);
        hashMap.put(FULL_SCHEMA.indexOf("modificationTime"), l3);
        hashMap.put(FULL_SCHEMA.indexOf("dataChange"), bl);
        optional2.ifPresent(mapValue -> hashMap.put(FULL_SCHEMA.indexOf("tags"), mapValue));
        optional3.ifPresent(l -> hashMap.put(FULL_SCHEMA.indexOf("baseRowId"), l));
        optional4.ifPresent(l -> hashMap.put(FULL_SCHEMA.indexOf("defaultRowCommitVersion"), l));
        optional5.ifPresent(dataFileStatistics -> hashMap.put(FULL_SCHEMA.indexOf("stats"), dataFileStatistics.serializeAsJson(structType)));
        return new GenericRow(FULL_SCHEMA, hashMap);
    }

    public AddFile(Row row) {
        super(row);
    }

    public String getPath() {
        return this.row.getString(this.getFieldIndex("path"));
    }

    public MapValue getPartitionValues() {
        return this.row.getMap(this.getFieldIndex("partitionValues"));
    }

    public long getSize() {
        return this.row.getLong(this.getFieldIndex("size"));
    }

    public long getModificationTime() {
        return this.row.getLong(this.getFieldIndex("modificationTime"));
    }

    public boolean getDataChange() {
        return this.row.getBoolean(this.getFieldIndex("dataChange"));
    }

    public Optional<DeletionVectorDescriptor> getDeletionVector() {
        int n = this.getFieldIndex("deletionVector");
        return Optional.ofNullable(this.row.isNullAt(n) ? null : DeletionVectorDescriptor.fromRow(this.row.getStruct(n)));
    }

    public Optional<MapValue> getTags() {
        int n = this.getFieldIndex("tags");
        return Optional.ofNullable(this.row.isNullAt(n) ? null : this.row.getMap(n));
    }

    public Optional<String> getStatsJson() {
        Optional<Integer> optional = this.getFieldIndexOpt("stats");
        return optional.map(n -> {
            if (this.row.isNullAt((int)n)) {
                return null;
            }
            return this.row.getString((int)n);
        });
    }

    public Optional<Long> getBaseRowId() {
        int n = this.getFieldIndex("baseRowId");
        return Optional.ofNullable(this.row.isNullAt(n) ? null : Long.valueOf(this.row.getLong(n)));
    }

    public Optional<Long> getDefaultRowCommitVersion() {
        int n = this.getFieldIndex("defaultRowCommitVersion");
        return Optional.ofNullable(this.row.isNullAt(n) ? null : Long.valueOf(this.row.getLong(n)));
    }

    public Optional<DataFileStatistics> getStats() {
        return this.getFieldIndexOpt("stats").flatMap(n -> this.row.isNullAt((int)n) ? Optional.empty() : StatsUtils.deserializeFromJson(this.row.getString((int)n)));
    }

    public Optional<Long> getNumRecords() {
        return this.getStats().map(DataFileStatistics::getNumRecords);
    }

    public AddFile withNewBaseRowId(long l) {
        return new AddFile(this.toRowWithOverriddenValue("baseRowId", l));
    }

    public AddFile withNewDefaultRowCommitVersion(long l) {
        return new AddFile(this.toRowWithOverriddenValue("defaultRowCommitVersion", l));
    }

    public Row toRemoveFileRow(boolean bl, Optional<Long> optional) {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(RemoveFile.FULL_SCHEMA.indexOf("path"), this.getPath());
        hashMap.put(RemoveFile.FULL_SCHEMA.indexOf("deletionTimestamp"), optional.orElse(System.currentTimeMillis()));
        hashMap.put(RemoveFile.FULL_SCHEMA.indexOf("dataChange"), bl);
        hashMap.put(RemoveFile.FULL_SCHEMA.indexOf("extendedFileMetadata"), true);
        hashMap.put(RemoveFile.FULL_SCHEMA.indexOf("partitionValues"), this.getPartitionValues());
        hashMap.put(RemoveFile.FULL_SCHEMA.indexOf("size"), this.getSize());
        this.getStatsJson().ifPresent(string -> hashMap.put(RemoveFile.FULL_SCHEMA.indexOf("stats"), string));
        this.getTags().ifPresent(mapValue -> hashMap.put(RemoveFile.FULL_SCHEMA.indexOf("tags"), mapValue));
        if (!this.row.isNullAt(this.getFieldIndex("deletionVector"))) {
            hashMap.put(RemoveFile.FULL_SCHEMA.indexOf("deletionVector"), this.row.getStruct(this.getFieldIndex("deletionVector")));
        }
        this.getBaseRowId().ifPresent(l -> hashMap.put(RemoveFile.FULL_SCHEMA.indexOf("baseRowId"), l));
        this.getDefaultRowCommitVersion().ifPresent(l -> hashMap.put(RemoveFile.FULL_SCHEMA.indexOf("defaultRowCommitVersion"), l));
        return new GenericRow(RemoveFile.FULL_SCHEMA, hashMap);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AddFile{");
        stringBuilder.append("path='").append(this.getPath()).append('\'');
        stringBuilder.append(", partitionValues=").append(VectorUtils.toJavaMap(this.getPartitionValues()));
        stringBuilder.append(", size=").append(this.getSize());
        stringBuilder.append(", modificationTime=").append(this.getModificationTime());
        stringBuilder.append(", dataChange=").append(this.getDataChange());
        stringBuilder.append(", deletionVector=").append(this.getDeletionVector());
        stringBuilder.append(", tags=").append(this.getTags().map(VectorUtils::toJavaMap));
        stringBuilder.append(", baseRowId=").append(this.getBaseRowId());
        stringBuilder.append(", defaultRowCommitVersion=").append(this.getDefaultRowCommitVersion());
        stringBuilder.append(", stats=").append(this.getStats().map(dataFileStatistics -> dataFileStatistics.serializeAsJson(null)).orElse(""));
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AddFile)) {
            return false;
        }
        AddFile addFile = (AddFile)object;
        return this.getSize() == addFile.getSize() && this.getModificationTime() == addFile.getModificationTime() && this.getDataChange() == addFile.getDataChange() && Objects.equals(this.getPath(), addFile.getPath()) && Objects.equals(VectorUtils.toJavaMap(this.getPartitionValues()), VectorUtils.toJavaMap(addFile.getPartitionValues())) && Objects.equals(this.getDeletionVector(), addFile.getDeletionVector()) && Objects.equals(this.getTags().map(VectorUtils::toJavaMap), addFile.getTags().map(VectorUtils::toJavaMap)) && Objects.equals(this.getBaseRowId(), addFile.getBaseRowId()) && Objects.equals(this.getDefaultRowCommitVersion(), addFile.getDefaultRowCommitVersion()) && Objects.equals(this.getStats(), addFile.getStats());
    }

    public int hashCode() {
        return Objects.hash(this.getPath(), VectorUtils.toJavaMap(this.getPartitionValues()), this.getSize(), this.getModificationTime(), this.getDataChange(), this.getDeletionVector(), this.getTags().map(VectorUtils::toJavaMap), this.getBaseRowId(), this.getDefaultRowCommitVersion(), this.getStats());
    }

    static {
        FULL_SCHEMA = SCHEMA_WITH_STATS = SCHEMA_WITHOUT_STATS.add(JSON_STATS_FIELD);
    }
}

