/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.tablefeatures.TableFeatures;
import io.delta.kernel.internal.util.ColumnMapping;
import io.delta.kernel.internal.util.IntervalParserUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class TableConfig<T> {
    public static final TableConfig<Boolean> APPEND_ONLY_ENABLED = new TableConfig<Boolean>("delta.appendOnly", "false", Boolean::valueOf, bl -> true, "needs to be a boolean.", true);
    public static final TableConfig<Boolean> CHANGE_DATA_FEED_ENABLED = new TableConfig<Boolean>("delta.enableChangeDataFeed", "false", Boolean::valueOf, bl -> true, "needs to be a boolean.", true);
    public static final TableConfig<String> CHECKPOINT_POLICY = new TableConfig<String>("delta.checkpointPolicy", "classic", string -> string, string -> string.equals("classic") || string.equals("v2"), "needs to be a string and one of 'classic' or 'v2'.", true);
    public static final TableConfig<Boolean> DELETION_VECTORS_CREATION_ENABLED = new TableConfig<Boolean>("delta.enableDeletionVectors", "false", Boolean::valueOf, bl -> true, "needs to be a boolean.", true);
    public static final TableConfig<Boolean> TYPE_WIDENING_ENABLED = new TableConfig<Boolean>("delta.enableTypeWidening", "false", Boolean::valueOf, bl -> true, "needs to be a boolean.", true);
    public static final TableConfig<Boolean> ROW_TRACKING_ENABLED = new TableConfig<Boolean>("delta.enableRowTracking", "false", Boolean::valueOf, bl -> true, "needs to be a boolean.", true);
    public static final TableConfig<Long> TOMBSTONE_RETENTION = new TableConfig<Long>("delta.deletedFileRetentionDuration", "interval 1 week", IntervalParserUtils::safeParseIntervalAsMillis, l -> l >= 0L, "needs to be provided as a calendar interval such as '2 weeks'. Months and years are not accepted. You may specify '365 days' for a year instead.", true);
    public static final TableConfig<Integer> CHECKPOINT_INTERVAL = new TableConfig<Integer>("delta.checkpointInterval", "10", Integer::valueOf, n -> n > 0, "needs to be a positive integer.", true);
    public static final TableConfig<Long> LOG_RETENTION = new TableConfig<Long>("delta.logRetentionDuration", "interval 30 days", IntervalParserUtils::safeParseIntervalAsMillis, l -> true, "needs to be provided as a calendar interval such as '2 weeks'. Months and years are not accepted. You may specify '365 days' for a year instead.", true);
    public static final TableConfig<Boolean> EXPIRED_LOG_CLEANUP_ENABLED = new TableConfig<Boolean>("delta.enableExpiredLogCleanup", "true", Boolean::valueOf, bl -> true, "needs to be a boolean.", true);
    public static final TableConfig<Boolean> IN_COMMIT_TIMESTAMPS_ENABLED = new TableConfig<Boolean>("delta.enableInCommitTimestamps", "false", string -> Boolean.valueOf(string), bl -> true, "needs to be a boolean.", true);
    public static final TableConfig<Optional<Long>> IN_COMMIT_TIMESTAMP_ENABLEMENT_VERSION = new TableConfig<Optional>("delta.inCommitTimestampEnablementVersion", null, string -> Optional.ofNullable(string).map(Long::valueOf), optional -> true, "needs to be a long.", true);
    public static final TableConfig<Optional<Long>> IN_COMMIT_TIMESTAMP_ENABLEMENT_TIMESTAMP = new TableConfig<Optional>("delta.inCommitTimestampEnablementTimestamp", null, string -> Optional.ofNullable(string).map(Long::valueOf), optional -> true, "needs to be a long.", true);
    public static final TableConfig<ColumnMapping.ColumnMappingMode> COLUMN_MAPPING_MODE = new TableConfig<ColumnMapping.ColumnMappingMode>("delta.columnMapping.mode", "none", ColumnMapping.ColumnMappingMode::fromTableConfig, columnMappingMode -> true, "Needs to be one of none, id, name.", true);
    public static final TableConfig<Long> COLUMN_MAPPING_MAX_COLUMN_ID = new TableConfig<Long>("delta.columnMapping.maxColumnId", "0", Long::valueOf, l -> l >= 0L, "", false);
    public static final TableConfig<Boolean> ICEBERG_COMPAT_V2_ENABLED = new TableConfig<Boolean>("delta.enableIcebergCompatV2", "false", Boolean::valueOf, bl -> true, "needs to be a boolean.", true);
    public static final TableConfig<Integer> DATA_SKIPPING_NUM_INDEXED_COLS = new TableConfig<Integer>("delta.dataSkippingNumIndexedCols", "32", Integer::valueOf, n -> n >= -1, "needs to be larger than or equal to -1.", true);
    public static final TableConfig<Boolean> ICEBERG_WRITER_COMPAT_V1_ENABLED = new TableConfig<Boolean>("delta.enableIcebergWriterCompatV1", "false", Boolean::valueOf, bl -> true, "needs to be a boolean.", true);
    private static final Collection<String> ALLOWED_UNIFORM_FORMATS = Collections.unmodifiableList(Arrays.asList("hudi", "iceberg"));
    public static final TableConfig<Set<String>> UNIVERSAL_FORMAT_ENABLED_FORMATS = new TableConfig<Set>("delta.universalFormat.enabledFormats", null, TableConfig::parseStringSet, set -> ALLOWED_UNIFORM_FORMATS.containsAll((Collection<?>)set), String.format("each value must in the the set: %s", ALLOWED_UNIFORM_FORMATS), true);
    public static final TableConfig<Boolean> VARIANT_SHREDDING_ENABLED = new TableConfig<Boolean>("delta.enableVariantShredding", "false", Boolean::valueOf, bl -> true, "needs to be a boolean.", true);
    public static final TableConfig<String> MATERIALIZED_ROW_ID_COLUMN_NAME = new TableConfig<String>("delta.rowTracking.materializedRowIdColumnName", null, string -> string, string -> true, "need to be a string.", false);
    public static final TableConfig<String> MATERIALIZED_ROW_COMMIT_VERSION_COLUMN_NAME = new TableConfig<String>("delta.rowTracking.materializedRowCommitVersionColumnName", null, string -> string, string -> true, "need to be a string.", false);
    private static final Map<String, TableConfig<?>> VALID_PROPERTIES = Collections.unmodifiableMap(new HashMap<String, TableConfig<?>>(){
        {
            TableConfig.addConfig(this, (TableConfig)APPEND_ONLY_ENABLED);
            TableConfig.addConfig(this, (TableConfig)CHANGE_DATA_FEED_ENABLED);
            TableConfig.addConfig(this, (TableConfig)CHECKPOINT_POLICY);
            TableConfig.addConfig(this, (TableConfig)DELETION_VECTORS_CREATION_ENABLED);
            TableConfig.addConfig(this, (TableConfig)TYPE_WIDENING_ENABLED);
            TableConfig.addConfig(this, (TableConfig)ROW_TRACKING_ENABLED);
            TableConfig.addConfig(this, (TableConfig)LOG_RETENTION);
            TableConfig.addConfig(this, (TableConfig)EXPIRED_LOG_CLEANUP_ENABLED);
            TableConfig.addConfig(this, (TableConfig)TOMBSTONE_RETENTION);
            TableConfig.addConfig(this, (TableConfig)CHECKPOINT_INTERVAL);
            TableConfig.addConfig(this, (TableConfig)IN_COMMIT_TIMESTAMPS_ENABLED);
            TableConfig.addConfig(this, (TableConfig)IN_COMMIT_TIMESTAMP_ENABLEMENT_VERSION);
            TableConfig.addConfig(this, (TableConfig)IN_COMMIT_TIMESTAMP_ENABLEMENT_TIMESTAMP);
            TableConfig.addConfig(this, (TableConfig)COLUMN_MAPPING_MODE);
            TableConfig.addConfig(this, (TableConfig)ICEBERG_COMPAT_V2_ENABLED);
            TableConfig.addConfig(this, (TableConfig)ICEBERG_WRITER_COMPAT_V1_ENABLED);
            TableConfig.addConfig(this, (TableConfig)COLUMN_MAPPING_MAX_COLUMN_ID);
            TableConfig.addConfig(this, (TableConfig)DATA_SKIPPING_NUM_INDEXED_COLS);
            TableConfig.addConfig(this, (TableConfig)UNIVERSAL_FORMAT_ENABLED_FORMATS);
            TableConfig.addConfig(this, (TableConfig)MATERIALIZED_ROW_ID_COLUMN_NAME);
            TableConfig.addConfig(this, (TableConfig)MATERIALIZED_ROW_COMMIT_VERSION_COLUMN_NAME);
        }
    });
    private final String key;
    private final String defaultValue;
    private final Function<String, T> fromString;
    private final Predicate<T> validator;
    private final boolean editable;
    private final String helpMessage;

    public static Map<String, String> validateDeltaProperties(Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            boolean bl;
            String string = entry.getKey().toLowerCase(Locale.ROOT);
            String string2 = entry.getValue();
            boolean bl2 = string.startsWith(TableFeatures.SET_TABLE_FEATURE_SUPPORTED_PREFIX);
            boolean bl3 = string.startsWith("delta.");
            boolean bl4 = bl = bl3 && !bl2;
            if (bl) {
                if (!VALID_PROPERTIES.containsKey(string)) {
                    throw DeltaErrors.unknownConfigurationException(entry.getKey());
                }
                TableConfig<?> tableConfig = VALID_PROPERTIES.get(string);
                if (!tableConfig.editable) {
                    throw DeltaErrors.cannotModifyTableProperty(entry.getKey());
                }
                super.validate(string2);
                hashMap.put(tableConfig.getKey(), string2);
                continue;
            }
            hashMap.put(entry.getKey(), string2);
        }
        return hashMap;
    }

    private static void addConfig(HashMap<String, TableConfig<?>> hashMap, TableConfig<?> tableConfig) {
        hashMap.put(tableConfig.getKey().toLowerCase(Locale.ROOT), tableConfig);
    }

    private TableConfig(String string, String string2, Function<String, T> function, Predicate<T> predicate, String string3, boolean bl) {
        this.key = string;
        this.defaultValue = string2;
        this.fromString = function;
        this.validator = predicate;
        this.helpMessage = string3;
        this.editable = bl;
    }

    public T fromMetadata(Metadata metadata) {
        return this.fromMetadata(metadata.getConfiguration());
    }

    public T fromMetadata(Map<String, String> map) {
        String string = map.getOrDefault(this.key, this.defaultValue);
        this.validate(string);
        return this.fromString.apply(string);
    }

    public String getKey() {
        return this.key;
    }

    private void validate(String string) {
        T t = this.fromString.apply(string);
        if (!this.validator.test(t)) {
            throw DeltaErrors.invalidConfigurationValueException(this.key, string, this.helpMessage);
        }
    }

    private static Set<String> parseStringSet(String string) {
        if (string == null || string.isEmpty()) {
            return Collections.emptySet();
        }
        String[] stringArray = string.split(",");
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : stringArray) {
            hashSet.add(string2.trim());
        }
        return hashSet;
    }

    public static class UniversalFormats {
        public static final String FORMAT_ICEBERG = "iceberg";
        public static final String FORMAT_HUDI = "hudi";
    }
}

