/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.Scan;
import io.delta.kernel.ScanBuilder;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.internal.ScanImpl;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.replay.LogReplay;
import io.delta.kernel.metrics.SnapshotReport;
import io.delta.kernel.types.StructType;
import java.util.Optional;

public class ScanBuilderImpl
implements ScanBuilder {
    private final Path dataPath;
    private final Protocol protocol;
    private final Metadata metadata;
    private final StructType snapshotSchema;
    private final LogReplay logReplay;
    private final SnapshotReport snapshotReport;
    private StructType readSchema;
    private Optional<Predicate> predicate;

    public ScanBuilderImpl(Path path, Protocol protocol, Metadata metadata, StructType structType, LogReplay logReplay, SnapshotReport snapshotReport) {
        this.dataPath = path;
        this.protocol = protocol;
        this.metadata = metadata;
        this.snapshotSchema = structType;
        this.logReplay = logReplay;
        this.readSchema = structType;
        this.predicate = Optional.empty();
        this.snapshotReport = snapshotReport;
    }

    @Override
    public ScanBuilder withFilter(Predicate predicate) {
        if (this.predicate.isPresent()) {
            throw new IllegalArgumentException("There already exists a filter in current builder");
        }
        this.predicate = Optional.of(predicate);
        return this;
    }

    @Override
    public ScanBuilder withReadSchema(StructType structType) {
        this.readSchema = structType;
        return this;
    }

    @Override
    public Scan build() {
        return new ScanImpl(this.snapshotSchema, this.readSchema, this.protocol, this.metadata, this.logReplay, this.predicate, this.dataPath, this.snapshotReport);
    }
}

