/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel;

import io.delta.kernel.DataWriteContext;
import io.delta.kernel.TransactionCommitResult;
import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.ConcurrentWriteException;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.internal.DataWriteContextImpl;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.TransactionImpl;
import io.delta.kernel.internal.actions.AddFile;
import io.delta.kernel.internal.actions.SingleAction;
import io.delta.kernel.internal.data.TransactionStateRow;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.icebergcompat.IcebergCompatV2MetadataValidatorAndUpdater;
import io.delta.kernel.internal.util.ColumnMapping;
import io.delta.kernel.internal.util.PartitionUtils;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.SchemaUtils;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterable;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.DataFileStatus;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Evolving
public interface Transaction {
    public StructType getSchema(Engine var1);

    public List<String> getPartitionColumns(Engine var1);

    public long getReadTableVersion();

    public Row getTransactionState(Engine var1);

    public TransactionCommitResult commit(Engine var1, CloseableIterable<Row> var2) throws ConcurrentWriteException;

    public void addDomainMetadata(String var1, String var2);

    public void removeDomainMetadata(String var1);

    public static CloseableIterator<FilteredColumnarBatch> transformLogicalData(Engine engine, Row row, CloseableIterator<FilteredColumnarBatch> closeableIterator, Map<String, Literal> map) {
        StructType structType = TransactionStateRow.getLogicalSchema(row);
        List<String> list = TransactionStateRow.getPartitionColumnsList(row);
        PartitionUtils.validateAndSanitizePartitionValues(structType, list, map);
        boolean bl = TransactionStateRow.isIcebergCompatV2Enabled(row);
        ColumnMapping.blockIfColumnMappingEnabled(row);
        String string = TransactionStateRow.getTablePath(row);
        return closeableIterator.map(filteredColumnarBatch -> {
            if (bl) {
                return filteredColumnarBatch;
            }
            ColumnarBatch columnarBatch = filteredColumnarBatch.getData();
            if (!columnarBatch.getSchema().equals(structType)) {
                throw DeltaErrors.dataSchemaMismatch(string, structType, columnarBatch.getSchema());
            }
            for (String string2 : list) {
                int n = SchemaUtils.findColIndex(columnarBatch.getSchema(), string2);
                if (n < 0) {
                    throw DeltaErrors.partitionColumnMissingInData(string, string2);
                }
                columnarBatch = columnarBatch.withDeletedColumnAt(n);
            }
            return new FilteredColumnarBatch(columnarBatch, filteredColumnarBatch.getSelectionVector());
        });
    }

    public static DataWriteContext getWriteContext(Engine engine, Row row, Map<String, Literal> map) {
        ColumnMapping.blockIfColumnMappingEnabled(row);
        StructType structType = TransactionStateRow.getLogicalSchema(row);
        List<String> list = TransactionStateRow.getPartitionColumnsList(row);
        map = PartitionUtils.validateAndSanitizePartitionValues(structType, list, map);
        String string = PartitionUtils.getTargetDirectory(TransactionStateRow.getTablePath(row), list, map);
        return new DataWriteContextImpl(string, map, TransactionImpl.getStatisticsColumns(row));
    }

    public static CloseableIterator<Row> generateAppendActions(Engine engine, Row row, CloseableIterator<DataFileStatus> closeableIterator, DataWriteContext dataWriteContext) {
        Preconditions.checkArgument(dataWriteContext instanceof DataWriteContextImpl, "DataWriteContext is not created by the `Transaction.getWriteContext()`");
        boolean bl = TransactionStateRow.isIcebergCompatV2Enabled(row);
        URI uRI = new Path(TransactionStateRow.getTablePath(row)).toUri();
        StructType structType = TransactionStateRow.getPhysicalSchema(row);
        return closeableIterator.map(dataFileStatus -> {
            if (bl) {
                IcebergCompatV2MetadataValidatorAndUpdater.validateDataFileStatus(dataFileStatus);
            }
            AddFile addFile = AddFile.convertDataFileStatus(structType, uRI, dataFileStatus, ((DataWriteContextImpl)dataWriteContext).getPartitionValues(), true, Collections.emptyMap());
            return SingleAction.createAddFileSingleAction(addFile.toRow());
        });
    }
}

