/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing.openshift;

import io.dekorate.DekorateException;
import io.dekorate.project.Project;
import io.dekorate.testing.Testing;
import io.dekorate.testing.WithProject;
import io.dekorate.utils.Serialization;
import io.fabric8.kubernetes.api.model.KubernetesList;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public interface WithOpenshiftResources
extends TestInstancePostProcessor,
WithProject {
    public static final String MANIFEST_PATH = "openshift.yml";

    default public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        Arrays.stream(testInstance.getClass().getDeclaredFields()).forEach(f -> this.injectOpenshiftResources(context, testInstance, (Field)f));
    }

    default public void injectOpenshiftResources(ExtensionContext context, Object testInstance, Field field) {
        if (!field.getType().isAssignableFrom(KubernetesList.class)) {
            return;
        }
        if (!Arrays.stream(field.getDeclaredAnnotations()).filter(a -> a.annotationType().getSimpleName().equalsIgnoreCase("Inject")).findAny().isPresent()) {
            return;
        }
        List projects = this.getProjects(context);
        ArrayList items = new ArrayList();
        for (Project project : projects) {
            items.addAll(this.getOpenshiftResources(context, project).getItems());
        }
        field.setAccessible(true);
        try {
            KubernetesList list = new KubernetesList();
            list.setItems(items);
            field.set(testInstance, list);
        }
        catch (IllegalAccessException e) {
            throw DekorateException.launderThrowable((Throwable)e);
        }
    }

    default public KubernetesList getOpenshiftResources(ExtensionContext context, Project project) {
        String key = Testing.KUBERNETES_LIST + project.getRoot();
        Object list = context.getStore(Testing.DEKORATE_STORE).get((Object)key);
        if (list instanceof KubernetesList) {
            return (KubernetesList)list;
        }
        list = this.fromManifest(project);
        context.getStore(Testing.DEKORATE_STORE).put((Object)key, list);
        return (KubernetesList)list;
    }

    default public KubernetesList fromManifest(Project project) {
        KubernetesList result = new KubernetesList();
        Path manifestUrl = project.getRoot().resolve(project.getBuildInfo().getClassOutputDir()).resolve(project.getDekorateOutputDir()).resolve(MANIFEST_PATH);
        if (!Files.exists(manifestUrl, new LinkOption[0])) {
            return result;
        }
        System.out.println("Apply test resources from:" + manifestUrl);
        try (InputStream is = manifestUrl.toUri().toURL().openStream();){
            result = Serialization.unmarshalAsList((InputStream)is);
        }
        catch (IOException e) {
            throw DekorateException.launderThrowable((Throwable)e);
        }
        return result;
    }
}

