/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.openshift.manifest;

import io.dekorate.AbstractKubernetesManifestGenerator;
import io.dekorate.ConfigurationRegistry;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.ResourceRegistry;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.configurator.ApplyDeployToApplicationConfiguration;
import io.dekorate.kubernetes.decorator.AddCommitIdAnnotationDecorator;
import io.dekorate.kubernetes.decorator.AddInitContainerDecorator;
import io.dekorate.kubernetes.decorator.AddLabelDecorator;
import io.dekorate.kubernetes.decorator.AddServiceResourceDecorator;
import io.dekorate.kubernetes.decorator.AddVcsUrlAnnotationDecorator;
import io.dekorate.kubernetes.decorator.ApplyDeploymentStrategyDecorator;
import io.dekorate.kubernetes.decorator.ApplyHeadlessDecorator;
import io.dekorate.kubernetes.decorator.ApplyReplicasToDeploymentDecorator;
import io.dekorate.kubernetes.decorator.ApplyReplicasToStatefulSetDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.RemoveAnnotationDecorator;
import io.dekorate.openshift.config.EditableOpenshiftConfig;
import io.dekorate.openshift.config.OpenshiftConfig;
import io.dekorate.openshift.config.OpenshiftConfigBuilder;
import io.dekorate.openshift.decorator.AddHostToRouteDecorator;
import io.dekorate.openshift.decorator.AddPortToRouteDecorator;
import io.dekorate.openshift.decorator.AddRouteDecorator;
import io.dekorate.openshift.decorator.AddServiceToRouteDecorator;
import io.dekorate.openshift.decorator.AddTlsConfigToRouteDecorator;
import io.dekorate.openshift.decorator.ApplyDeploymentConfigStrategyDecorator;
import io.dekorate.openshift.decorator.ApplyDeploymentTriggerDecorator;
import io.dekorate.openshift.decorator.ApplyReplicasToDeploymentConfigDecorator;
import io.dekorate.option.config.VcsConfig;
import io.dekorate.project.ApplyProjectInfo;
import io.dekorate.project.Project;
import io.dekorate.utils.Git;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import java.nio.file.Path;
import java.util.Optional;

public class OpenshiftManifestGenerator
extends AbstractKubernetesManifestGenerator<OpenshiftConfig> {
    private static final String OPENSHIFT = "openshift";
    public static final ConfigKey<String> RUNTIME_TYPE = new ConfigKey("RUNTIME_TYPE", String.class);
    private final Logger LOGGER = LoggerFactory.getLogger();

    public OpenshiftManifestGenerator(ResourceRegistry resourceRegistry, ConfigurationRegistry configurationRegistry) {
        super(resourceRegistry, configurationRegistry);
        resourceRegistry.groups().putIfAbsent(OPENSHIFT, new KubernetesListBuilder());
    }

    public int order() {
        return 300;
    }

    public String getKey() {
        return OPENSHIFT;
    }

    public void generate(OpenshiftConfig config) {
        this.LOGGER.info("Processing openshift configuration.");
        this.initializeRegistry(config);
        if (config.isHeadless()) {
            this.resourceRegistry.decorate(OPENSHIFT, (Decorator)new ApplyHeadlessDecorator(config.getName()));
        }
        for (Container container : config.getInitContainers()) {
            this.resourceRegistry.decorate(OPENSHIFT, (Decorator)new AddInitContainerDecorator(config.getName(), container));
        }
        if (config.getPorts().length > 0) {
            this.resourceRegistry.decorate(OPENSHIFT, (Decorator)new AddServiceResourceDecorator((BaseConfig)config));
        }
        this.addDecorators(OPENSHIFT, config);
    }

    public ConfigurationSupplier<OpenshiftConfig> getFallbackConfig() {
        Project p = this.getProject();
        return new ConfigurationSupplier((VisitableBuilder)((OpenshiftConfigBuilder)new OpenshiftConfigBuilder().accept(new Visitor[]{new ApplyDeployToApplicationConfiguration()})).accept(new Visitor[]{new ApplyProjectInfo(p)}));
    }

    protected void addDecorators(String group, OpenshiftConfig config) {
        super.addDecorators(group, (BaseConfig)config);
        ImageConfiguration imageConfig = this.getImageConfiguration(config);
        if (config.getReplicas() != 1) {
            if ("StatefulSet".equalsIgnoreCase(config.getDeploymentKind())) {
                this.resourceRegistry.decorate(group, (Decorator)new ApplyReplicasToStatefulSetDecorator(config.getName(), config.getReplicas().intValue()));
            } else if ("Deployment".equalsIgnoreCase(config.getDeploymentKind())) {
                this.resourceRegistry.decorate(group, (Decorator)new ApplyReplicasToDeploymentDecorator(config.getName(), config.getReplicas().intValue()));
            } else {
                this.resourceRegistry.decorate(group, (Decorator)new ApplyReplicasToDeploymentConfigDecorator(config.getName(), config.getReplicas()));
            }
        }
        this.resourceRegistry.decorate(group, (Decorator)new ApplyDeploymentTriggerDecorator(config.getName(), imageConfig.getName() + ":" + imageConfig.getVersion()));
        this.resourceRegistry.decorate(group, (Decorator)new AddRouteDecorator(config));
        this.resourceRegistry.decorate(group, (Decorator)new AddHostToRouteDecorator(config));
        this.resourceRegistry.decorate(group, (Decorator)new AddPortToRouteDecorator(config));
        this.resourceRegistry.decorate(group, (Decorator)new AddServiceToRouteDecorator(config));
        this.resourceRegistry.decorate(group, (Decorator)new AddTlsConfigToRouteDecorator(config));
        if (config.hasAttribute(RUNTIME_TYPE)) {
            this.resourceRegistry.decorate(group, (Decorator)new AddLabelDecorator(config.getName(), new Label("app.openshift.io/runtime", (String)config.getAttribute(RUNTIME_TYPE), new String[0])));
        }
        this.resourceRegistry.decorate(group, (Decorator)new RemoveAnnotationDecorator(config.getName(), "app.dekorate.io/vcs-url"));
        Project project = this.getProject();
        Optional vcsConfig = this.configurationRegistry.get(VcsConfig.class);
        String remote = vcsConfig.map(VcsConfig::getRemote).orElse("origin");
        boolean httpsPreferred = vcsConfig.map(VcsConfig::isHttpsPreferred).orElse(false);
        String vcsUrl = project.getScmInfo() != null && Strings.isNotNullOrEmpty((String)((String)project.getScmInfo().getRemote().get("origin"))) ? Git.getRemoteUrl((Path)project.getRoot(), (String)remote, (boolean)httpsPreferred).orElse("<<unknown>>") : "<<unknown>>";
        this.resourceRegistry.decorate(group, (Decorator)new AddVcsUrlAnnotationDecorator(config.getName(), "app.openshift.io/vcs-url", vcsUrl));
        this.resourceRegistry.decorate(group, (Decorator)new AddCommitIdAnnotationDecorator());
        if ("Deployment".equalsIgnoreCase(config.getDeploymentKind())) {
            this.resourceRegistry.decorate(group, (Decorator)new ApplyDeploymentStrategyDecorator(config.getName(), config.getDeploymentStrategy(), config.getRollingUpdate()));
        } else if ("DeploymentConfig".equalsIgnoreCase(config.getDeploymentKind())) {
            this.resourceRegistry.decorate(group, (Decorator)new ApplyDeploymentConfigStrategyDecorator(config.getName(), config.getDeploymentStrategy(), config.getRollingUpdate()));
        }
    }

    public boolean accepts(Class<? extends Configuration> type) {
        return type.equals(OpenshiftConfig.class) || type.equals(EditableOpenshiftConfig.class);
    }
}

