/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.stretch;

import androidx.annotation.NonNull;
import com.otaliastudios.transcoder.stretch.AudioStretcher;
import java.nio.ShortBuffer;
import java.util.Random;

public class InsertAudioStretcher
implements AudioStretcher {
    private static final Random NOISE = new Random();

    private static short noise() {
        return (short)NOISE.nextInt(300);
    }

    private static float ratio(int remaining, int all) {
        return (float)remaining / (float)all;
    }

    @Override
    public void stretch(@NonNull ShortBuffer input, @NonNull ShortBuffer output, int channels) {
        if (input.remaining() >= output.remaining()) {
            throw new IllegalArgumentException("Illegal use of AudioStretcher.INSERT");
        }
        if (channels != 1 && channels != 2) {
            throw new IllegalArgumentException("Illegal use of AudioStretcher.INSERT. Channels:" + channels);
        }
        int inputSamples = input.remaining() / channels;
        int fakeSamples = (int)Math.floor((double)(output.remaining() - input.remaining()) / (double)channels);
        int remainingInputSamples = inputSamples;
        int remainingFakeSamples = fakeSamples;
        float remainingInputSamplesRatio = InsertAudioStretcher.ratio(remainingInputSamples, inputSamples);
        float remainingFakeSamplesRatio = InsertAudioStretcher.ratio(remainingFakeSamples, fakeSamples);
        while (remainingInputSamples > 0 && remainingFakeSamples > 0) {
            if (remainingInputSamplesRatio >= remainingFakeSamplesRatio) {
                output.put(input.get());
                if (channels == 2) {
                    output.put(input.get());
                }
                remainingInputSamplesRatio = InsertAudioStretcher.ratio(--remainingInputSamples, inputSamples);
                continue;
            }
            output.put(InsertAudioStretcher.noise());
            if (channels == 2) {
                output.put(InsertAudioStretcher.noise());
            }
            remainingFakeSamplesRatio = InsertAudioStretcher.ratio(--remainingFakeSamples, inputSamples);
        }
    }
}

