/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.resample;

import androidx.annotation.NonNull;
import com.otaliastudios.transcoder.resample.AudioResampler;
import java.nio.ShortBuffer;

public class UpsampleAudioResampler
implements AudioResampler {
    private static float ratio(int remaining, int all) {
        return (float)remaining / (float)all;
    }

    @Override
    public void resample(@NonNull ShortBuffer inputBuffer, int inputSampleRate, @NonNull ShortBuffer outputBuffer, int outputSampleRate, int channels) {
        if (inputSampleRate > outputSampleRate) {
            throw new IllegalArgumentException("Illegal use of UpsampleAudioResampler");
        }
        if (channels != 1 && channels != 2) {
            throw new IllegalArgumentException("Illegal use of UpsampleAudioResampler. Channels:" + channels);
        }
        int inputSamples = inputBuffer.remaining() / channels;
        int outputSamples = (int)Math.ceil((double)inputSamples * ((double)outputSampleRate / (double)inputSampleRate));
        int fakeSamples = outputSamples - inputSamples;
        int remainingInputSamples = inputSamples;
        int remainingFakeSamples = fakeSamples;
        float remainingInputSamplesRatio = UpsampleAudioResampler.ratio(remainingInputSamples, inputSamples);
        float remainingFakeSamplesRatio = UpsampleAudioResampler.ratio(remainingFakeSamples, fakeSamples);
        while (remainingInputSamples > 0 && remainingFakeSamples > 0) {
            if (remainingInputSamplesRatio >= remainingFakeSamplesRatio) {
                outputBuffer.put(inputBuffer.get());
                if (channels == 2) {
                    outputBuffer.put(inputBuffer.get());
                }
                remainingInputSamplesRatio = UpsampleAudioResampler.ratio(--remainingInputSamples, inputSamples);
                continue;
            }
            outputBuffer.put(UpsampleAudioResampler.fakeSample(outputBuffer, inputBuffer, 1, channels));
            if (channels == 2) {
                outputBuffer.put(UpsampleAudioResampler.fakeSample(outputBuffer, inputBuffer, 2, channels));
            }
            remainingFakeSamplesRatio = UpsampleAudioResampler.ratio(--remainingFakeSamples, fakeSamples);
        }
    }

    private static short fakeSample(@NonNull ShortBuffer output, @NonNull ShortBuffer input, int channel, int channels) {
        return output.get(output.position() - channels);
    }
}

