/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.utils;

import android.media.MediaCodec;
import android.media.MediaFormat;
import androidx.annotation.NonNull;
import com.otaliastudios.transcoder.common.TrackStatus;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.sink.DataSink;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\t\u0010\u0011\u001a\u00020\u000bH\u0096\u0001J\u0019\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0096\u0001J\u0011\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0096\u0001J'\u0010\u0019\u001a\u00020\u000b2\r\b\u0001\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u001a2\r\b\u0001\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001aH\u0096\u0001J'\u0010\u001d\u001a\u00020\u000b2\r\b\u0001\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u001a2\r\b\u0001\u0010\u001e\u001a\u00070\u001f\u00a2\u0006\u0002\b\u001aH\u0096\u0001J\t\u0010 \u001a\u00020\u000bH\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/otaliastudios/transcoder/internal/utils/EosIgnoringDataSink;", "Lcom/otaliastudios/transcoder/sink/DataSink;", "sink", "ignore", "Lkotlin/Function0;", "", "<init>", "(Lcom/otaliastudios/transcoder/sink/DataSink;Lkotlin/jvm/functions/Function0;)V", "info", "Landroid/media/MediaCodec$BufferInfo;", "writeTrack", "", "type", "Lcom/otaliastudios/transcoder/common/TrackType;", "byteBuffer", "Ljava/nio/ByteBuffer;", "bufferInfo", "release", "setLocation", "latitude", "", "longitude", "setOrientation", "orientation", "", "setTrackFormat", "Lkotlin/jvm/internal/EnhancedNullability;", "format", "Landroid/media/MediaFormat;", "setTrackStatus", "status", "Lcom/otaliastudios/transcoder/common/TrackStatus;", "stop", "lib_release"})
final class EosIgnoringDataSink
implements DataSink {
    @NotNull
    private final DataSink sink;
    @NotNull
    private final Function0<Boolean> ignore;
    @NotNull
    private final MediaCodec.BufferInfo info;

    public EosIgnoringDataSink(@NotNull DataSink sink, @NotNull Function0<Boolean> ignore) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter(ignore, (String)"ignore");
        this.sink = sink;
        this.ignore = ignore;
        this.info = new MediaCodec.BufferInfo();
    }

    @Override
    public void setOrientation(int orientation) {
        this.sink.setOrientation(orientation);
    }

    @Override
    public void setLocation(double latitude, double longitude) {
        this.sink.setLocation(latitude, longitude);
    }

    @Override
    public void setTrackStatus(@NonNull @NotNull TrackType type, @NonNull @NotNull TrackStatus status) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        this.sink.setTrackStatus(type, status);
    }

    @Override
    public void setTrackFormat(@NonNull @NotNull TrackType type, @NonNull @NotNull MediaFormat format) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.sink.setTrackFormat(type, format);
    }

    @Override
    public void stop() {
        this.sink.stop();
    }

    @Override
    public void release() {
        this.sink.release();
    }

    @Override
    public void writeTrack(@NotNull TrackType type, @NotNull ByteBuffer byteBuffer, @NotNull MediaCodec.BufferInfo bufferInfo) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        Intrinsics.checkNotNullParameter((Object)bufferInfo, (String)"bufferInfo");
        if (((Boolean)this.ignore.invoke()).booleanValue()) {
            int flags = bufferInfo.flags & 0xFFFFFFFB;
            if (bufferInfo.size > 0 || flags != 0) {
                this.info.set(bufferInfo.offset, bufferInfo.size, bufferInfo.presentationTimeUs, flags);
                this.sink.writeTrack(type, byteBuffer, this.info);
            }
        } else {
            this.sink.writeTrack(type, byteBuffer, bufferInfo);
        }
    }
}

