/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal.utils;

import android.media.MediaFormat;
import androidx.annotation.NonNull;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.source.DataSource;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016J\u0018\u0010\t\u001a\u00020\u00052\r\b\u0001\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0096\u0001J\t\u0010\r\u001a\u00020\u000eH\u0096\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u0096\u0001J\u0010\u0010\u0011\u001a\t\u0018\u00010\u0012\u00a2\u0006\u0002\b\fH\u0097\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u0096\u0001J\t\u0010\u0015\u001a\u00020\u0010H\u0096\u0001J\u001f\u0010\u0016\u001a\t\u0018\u00010\u0017\u00a2\u0006\u0002\b\f2\r\b\u0001\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0097\u0001J\t\u0010\u0018\u001a\u00020\u000eH\u0096\u0001J\t\u0010\u0019\u001a\u00020\u0005H\u0096\u0001J\u0018\u0010\u001a\u001a\u00020\u000e2\r\b\u0001\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\fH\u0096\u0001J\u0018\u0010\u001d\u001a\u00020\u000e2\r\b\u0001\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0096\u0001J\u0011\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0010H\u0096\u0001J\u0018\u0010 \u001a\u00020\u000e2\r\b\u0001\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/otaliastudios/transcoder/internal/utils/EosForcingDataSource;", "Lcom/otaliastudios/transcoder/source/DataSource;", "source", "force", "Lkotlin/Function0;", "", "<init>", "(Lcom/otaliastudios/transcoder/source/DataSource;Lkotlin/jvm/functions/Function0;)V", "isDrained", "canReadTrack", "type", "Lcom/otaliastudios/transcoder/common/TrackType;", "Lkotlin/jvm/internal/EnhancedNullability;", "deinitialize", "", "getDurationUs", "", "getLocation", "", "getOrientation", "", "getPositionUs", "getTrackFormat", "Landroid/media/MediaFormat;", "initialize", "isInitialized", "readTrack", "chunk", "Lcom/otaliastudios/transcoder/source/DataSource$Chunk;", "releaseTrack", "seekTo", "desiredPositionUs", "selectTrack", "lib_release"})
final class EosForcingDataSource
implements DataSource {
    @NotNull
    private final DataSource source;
    @NotNull
    private final Function0<Boolean> force;

    public EosForcingDataSource(@NotNull DataSource source, @NotNull Function0<Boolean> force) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(force, (String)"force");
        this.source = source;
        this.force = force;
    }

    @Override
    public void initialize() {
        this.source.initialize();
    }

    @Override
    public void deinitialize() {
        this.source.deinitialize();
    }

    @Override
    public boolean isInitialized() {
        return this.source.isInitialized();
    }

    @Override
    public int getOrientation() {
        return this.source.getOrientation();
    }

    @Override
    @androidx.annotation.Nullable
    @Nullable
    public double[] getLocation() {
        return this.source.getLocation();
    }

    @Override
    public long getDurationUs() {
        return this.source.getDurationUs();
    }

    @Override
    @androidx.annotation.Nullable
    @Nullable
    public MediaFormat getTrackFormat(@NonNull @NotNull TrackType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.source.getTrackFormat(type);
    }

    @Override
    public void selectTrack(@NonNull @NotNull TrackType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.source.selectTrack(type);
    }

    @Override
    public long seekTo(long desiredPositionUs) {
        return this.source.seekTo(desiredPositionUs);
    }

    @Override
    public boolean canReadTrack(@NonNull @NotNull TrackType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.source.canReadTrack(type);
    }

    @Override
    public void readTrack(@NonNull @NotNull DataSource.Chunk chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        this.source.readTrack(chunk);
    }

    @Override
    public long getPositionUs() {
        return this.source.getPositionUs();
    }

    @Override
    public void releaseTrack(@NonNull @NotNull TrackType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.source.releaseTrack(type);
    }

    @Override
    public boolean isDrained() {
        return (Boolean)this.force.invoke() != false || this.source.isDrained();
    }
}

