/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal;

import android.media.MediaFormat;
import com.otaliastudios.transcoder.common.TrackStatus;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.DataSources;
import com.otaliastudios.transcoder.internal.media.MediaFormatProvider;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.TrackMap;
import com.otaliastudios.transcoder.internal.utils.TrackMapKt;
import com.otaliastudios.transcoder.source.DataSource;
import com.otaliastudios.transcoder.strategy.TrackStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ \u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\bH\u0002J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J4\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00100\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010!H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/otaliastudios/transcoder/internal/Tracks;", "", "strategies", "Lcom/otaliastudios/transcoder/internal/utils/TrackMap;", "Lcom/otaliastudios/transcoder/strategy/TrackStrategy;", "sources", "Lcom/otaliastudios/transcoder/internal/DataSources;", "videoRotation", "", "forceCompression", "", "<init>", "(Lcom/otaliastudios/transcoder/internal/utils/TrackMap;Lcom/otaliastudios/transcoder/internal/DataSources;IZ)V", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "all", "Lcom/otaliastudios/transcoder/common/TrackStatus;", "getAll", "()Lcom/otaliastudios/transcoder/internal/utils/TrackMap;", "outputFormats", "Landroid/media/MediaFormat;", "getOutputFormats", "active", "getActive", "resolveVideoStatus", "status", "rotation", "resolveAudioStatus", "resolveTrack", "Lkotlin/Pair;", "type", "Lcom/otaliastudios/transcoder/common/TrackType;", "strategy", "", "Lcom/otaliastudios/transcoder/source/DataSource;", "lib_release"})
@SourceDebugExtension(value={"SMAP\nTracks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Tracks.kt\ncom/otaliastudios/transcoder/internal/Tracks\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1#2:84\n1#2:95\n1611#3,9:85\n1863#3:94\n1864#3:96\n1620#3:97\n*S KotlinDebug\n*F\n+ 1 Tracks.kt\ncom/otaliastudios/transcoder/internal/Tracks\n*L\n66#1:95\n66#1:85,9\n66#1:94\n66#1:96\n66#1:97\n*E\n"})
public final class Tracks {
    @NotNull
    private final Logger log;
    @NotNull
    private final TrackMap<TrackStatus> all;
    @NotNull
    private final TrackMap<MediaFormat> outputFormats;
    @NotNull
    private final TrackMap<TrackStatus> active;

    public Tracks(@NotNull TrackMap<TrackStrategy> strategies, @NotNull DataSources sources, int videoRotation, boolean forceCompression) {
        TrackStatus it;
        Intrinsics.checkNotNullParameter(strategies, (String)"strategies");
        Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
        this.log = new Logger("Tracks");
        Object object = this.resolveTrack(TrackType.AUDIO, strategies.getAudio(), (List)sources.audioOrNull());
        Object audioFormat = (MediaFormat)object.component1();
        TrackStatus audioStatus = (TrackStatus)((Object)object.component2());
        Pair<MediaFormat, TrackStatus> pair = this.resolveTrack(TrackType.VIDEO, strategies.getVideo(), (List)sources.videoOrNull());
        MediaFormat videoFormat = (MediaFormat)pair.component1();
        TrackStatus videoStatus = (TrackStatus)((Object)pair.component2());
        this.all = TrackMapKt.trackMapOf(this.resolveVideoStatus(videoStatus, forceCompression, videoRotation), this.resolveAudioStatus(audioStatus, forceCompression));
        this.outputFormats = TrackMapKt.trackMapOf(videoFormat, audioFormat);
        this.log.i("init: videoStatus=" + videoStatus + ", resolvedVideoStatus=" + (Object)((Object)this.all.getVideo()) + ", videoFormat=" + videoFormat);
        this.log.i("init: audioStatus=" + audioStatus + ", resolvedAudioStatus=" + (Object)((Object)this.all.getAudio()) + ", audioFormat=" + audioFormat);
        object = this.all.getVideo();
        audioFormat = (TrackStatus)((Object)object);
        Tracks tracks = this;
        boolean bl = false;
        boolean bl2 = it.isTranscoding();
        Object object2 = bl2 ? object : null;
        object = this.all.getAudio();
        it = (TrackStatus)((Object)object);
        Object object3 = object2;
        boolean bl3 = false;
        boolean bl4 = it.isTranscoding();
        tracks.active = TrackMapKt.trackMapOf(object3, bl4 ? object : null);
    }

    @NotNull
    public final TrackMap<TrackStatus> getAll() {
        return this.all;
    }

    @NotNull
    public final TrackMap<MediaFormat> getOutputFormats() {
        return this.outputFormats;
    }

    @NotNull
    public final TrackMap<TrackStatus> getActive() {
        return this.active;
    }

    private final TrackStatus resolveVideoStatus(TrackStatus status, boolean forceCompression, int rotation) {
        boolean force = forceCompression || rotation != 0;
        boolean canForce = status == TrackStatus.PASS_THROUGH;
        return canForce && force ? TrackStatus.COMPRESSING : status;
    }

    private final TrackStatus resolveAudioStatus(TrackStatus status, boolean forceCompression) {
        boolean force = forceCompression;
        boolean canForce = status == TrackStatus.PASS_THROUGH;
        return canForce && force ? TrackStatus.COMPRESSING : status;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<MediaFormat, TrackStatus> resolveTrack(TrackType type, TrackStrategy strategy, List<? extends DataSource> sources) {
        Pair pair;
        void $this$mapNotNullTo$iv$iv;
        List<? extends DataSource> list = sources;
        this.log.i("resolveTrack(" + type + "), sources=" + (list != null ? Integer.valueOf(list.size()) : null) + ", strategy=" + Reflection.getOrCreateKotlinClass(strategy.getClass()).getSimpleName());
        if (sources == null) {
            return TuplesKt.to((Object)new MediaFormat(), (Object)((Object)TrackStatus.ABSENT));
        }
        MediaFormatProvider provider = new MediaFormatProvider();
        Iterable $this$mapNotNull$iv = sources;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            MediaFormat it$iv$iv;
            MediaFormat format;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DataSource it = (DataSource)element$iv$iv;
            boolean bl2 = false;
            if ((it.getTrackFormat(type) == null ? null : provider.provideMediaFormat(it, type, format)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List inputs = (List)destination$iv$iv;
        int n = inputs.size();
        if (n == 0) {
            pair = TuplesKt.to((Object)new MediaFormat(), (Object)((Object)TrackStatus.ABSENT));
        } else if (n == sources.size()) {
            MediaFormat output = new MediaFormat();
            TrackStatus trackStatus = strategy.createOutputFormat(inputs, output);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)trackStatus), (String)"createOutputFormat(...)");
            TrackStatus status = trackStatus;
            pair = TuplesKt.to((Object)output, (Object)((Object)status));
        } else {
            throw new IllegalStateException(("Of all " + type + " sources, some have a " + type + " track, some don't.").toString());
        }
        return pair;
    }
}

