/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.transcoder.internal;

import android.media.MediaFormat;
import com.otaliastudios.transcoder.common.TrackStatus;
import com.otaliastudios.transcoder.common.TrackType;
import com.otaliastudios.transcoder.internal.DataSources;
import com.otaliastudios.transcoder.internal.Segment;
import com.otaliastudios.transcoder.internal.Tracks;
import com.otaliastudios.transcoder.internal.pipeline.Pipeline;
import com.otaliastudios.transcoder.internal.utils.Logger;
import com.otaliastudios.transcoder.internal.utils.MutableTrackMap;
import com.otaliastudios.transcoder.internal.utils.TrackMapKt;
import com.otaliastudios.transcoder.source.DataSource;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012*\u0010\u0006\u001a&\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\tH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0006\u001a&\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/otaliastudios/transcoder/internal/Segments;", "", "sources", "Lcom/otaliastudios/transcoder/internal/DataSources;", "tracks", "Lcom/otaliastudios/transcoder/internal/Tracks;", "factory", "Lkotlin/Function5;", "Lcom/otaliastudios/transcoder/common/TrackType;", "", "Lcom/otaliastudios/transcoder/common/TrackStatus;", "Landroid/media/MediaFormat;", "Lcom/otaliastudios/transcoder/internal/pipeline/Pipeline;", "<init>", "(Lcom/otaliastudios/transcoder/internal/DataSources;Lcom/otaliastudios/transcoder/internal/Tracks;Lkotlin/jvm/functions/Function5;)V", "log", "Lcom/otaliastudios/transcoder/internal/utils/Logger;", "current", "Lcom/otaliastudios/transcoder/internal/utils/MutableTrackMap;", "Lcom/otaliastudios/transcoder/internal/Segment;", "currentIndex", "getCurrentIndex", "()Lcom/otaliastudios/transcoder/internal/utils/MutableTrackMap;", "requestedIndex", "hasNext", "", "type", "next", "release", "", "tryCreateSegment", "index", "destroySegment", "segment", "lib_release"})
@SourceDebugExtension(value={"SMAP\nSegments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Segments.kt\ncom/otaliastudios/transcoder/internal/Segments\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1#2:112\n1755#3,3:113\n*S KotlinDebug\n*F\n+ 1 Segments.kt\ncom/otaliastudios/transcoder/internal/Segments\n*L\n80#1:113,3\n*E\n"})
public final class Segments {
    @NotNull
    private final DataSources sources;
    @NotNull
    private final Tracks tracks;
    @NotNull
    private final Function5<TrackType, Integer, Integer, TrackStatus, MediaFormat, Pipeline> factory;
    @NotNull
    private final Logger log;
    @NotNull
    private final MutableTrackMap<Segment> current;
    @NotNull
    private final MutableTrackMap<Integer> currentIndex;
    @NotNull
    private final MutableTrackMap<Integer> requestedIndex;

    public Segments(@NotNull DataSources sources, @NotNull Tracks tracks, @NotNull Function5<? super TrackType, ? super Integer, ? super Integer, ? super TrackStatus, ? super MediaFormat, Pipeline> factory) {
        Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)tracks, (String)"tracks");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        this.sources = sources;
        this.tracks = tracks;
        this.factory = factory;
        this.log = new Logger("Segments");
        this.current = TrackMapKt.mutableTrackMapOf(null, null);
        this.currentIndex = TrackMapKt.mutableTrackMapOf(-1, -1);
        this.requestedIndex = TrackMapKt.mutableTrackMapOf(0, 0);
    }

    @NotNull
    public final MutableTrackMap<Integer> getCurrentIndex() {
        return this.currentIndex;
    }

    public final boolean hasNext(@NotNull TrackType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (!this.sources.has(type)) {
            return false;
        }
        Segment segment = (Segment)this.current.getOrNull(type);
        if (segment == null) {
            return true;
        }
        Segment segment2 = segment;
        List list = (List)this.sources.getOrNull(type);
        if (list == null) {
            return false;
        }
        int lastIndex = CollectionsKt.getLastIndex((List)list);
        return segment2.canAdvance() || segment2.getIndex() < lastIndex;
    }

    public final boolean hasNext() {
        return this.hasNext(TrackType.VIDEO) || this.hasNext(TrackType.AUDIO);
    }

    @Nullable
    public final Segment next(@NotNull TrackType type) {
        Segment segment;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        int currentIndex = ((Number)this.currentIndex.get(type)).intValue();
        int requestedIndex = ((Number)this.requestedIndex.get(type)).intValue();
        if (requestedIndex < currentIndex) {
            throw new IllegalStateException(("Requested index " + requestedIndex + " smaller than " + currentIndex + ".").toString());
        }
        if (requestedIndex > currentIndex) {
            segment = this.tryCreateSegment(type, requestedIndex);
        } else if (((Segment)this.current.get(type)).canAdvance()) {
            segment = (Segment)this.current.get(type);
        } else {
            this.destroySegment((Segment)this.current.get(type));
            segment = this.next(type);
        }
        return segment;
    }

    public final void release() {
        block1: {
            Segment it;
            Segment segment = (Segment)this.current.videoOrNull();
            if (segment != null) {
                it = segment;
                boolean bl = false;
                this.destroySegment(it);
            }
            Segment segment2 = (Segment)this.current.audioOrNull();
            if (segment2 == null) break block1;
            it = segment2;
            boolean bl = false;
            this.destroySegment(it);
        }
    }

    private final Segment tryCreateSegment(TrackType type, int index) {
        Segment segment;
        DataSource dataSource = (DataSource)CollectionsKt.getOrNull((List)this.sources.get(type), (int)index);
        if (dataSource == null) {
            return null;
        }
        DataSource source = dataSource;
        this.log.i("tryCreateSegment(" + type + ", " + index + "): created!");
        if (this.tracks.getActive().has(type)) {
            source.selectTrack(type);
            TrackType other = switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1 -> TrackType.VIDEO;
                case 2 -> TrackType.AUDIO;
                default -> throw new NoWhenBranchMatchedException();
            };
            if (this.tracks.getActive().has(other)) {
                boolean bl;
                block11: {
                    Iterable $this$any$iv = (Iterable)this.sources.get(other);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            DataSource it = (DataSource)element$iv;
                            boolean bl2 = false;
                            if (!(it == source)) continue;
                            bl = true;
                            break block11;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    source.selectTrack(other);
                }
            }
        }
        this.currentIndex.set(type, index);
        Pipeline pipeline = (Pipeline)this.factory.invoke((Object)type, (Object)index, (Object)this.sources.get(type).size(), (Object)this.tracks.getAll().get(type), (Object)this.tracks.getOutputFormats().get(type));
        Segment it = segment = new Segment(type, index, pipeline);
        boolean bl = false;
        this.current.set(type, it);
        return segment;
    }

    private final void destroySegment(Segment segment) {
        segment.release();
        DataSource source = (DataSource)this.sources.get(segment.getType()).get(segment.getIndex());
        if (this.tracks.getActive().has(segment.getType())) {
            source.releaseTrack(segment.getType());
        }
        this.requestedIndex.set(segment.getType(), segment.getIndex() + 1);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TrackType.values().length];
            try {
                nArray[TrackType.AUDIO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TrackType.VIDEO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

