/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.sample.app.resources;

import io.debezium.runtime.Debezium;
import io.debezium.runtime.DebeziumConnectorRegistry;
import io.debezium.runtime.DebeziumStatus;
import io.quarkus.sample.app.dto.EngineInformation;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;

@Path(value="engine")
@ApplicationScoped
public class EngineResource {
    private final DebeziumConnectorRegistry registry;

    public EngineResource(DebeziumConnectorRegistry registry) {
        this.registry = registry;
    }

    @GET
    @Path(value="manifest")
    public Response engines() {
        return Response.ok(this.registry.engines().stream().map(engine -> new EngineInformation(engine.manifest().id(), engine.connector().name())).toList()).build();
    }

    @GET
    @Path(value="status")
    public DebeziumStatus getState() {
        return ((Debezium)this.registry.engines().getFirst()).status();
    }
}

