/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.sample.app.events;

import io.debezium.runtime.events.DebeziumHeartbeat;
import io.debezium.runtime.events.DefaultEngine;
import io.debezium.runtime.events.Engine;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import java.util.concurrent.atomic.AtomicReference;

@ApplicationScoped
public class HeartbeatEventObserver {
    private final AtomicReference<DebeziumHeartbeat> defaultHeartbeats = new AtomicReference();
    private final AtomicReference<DebeziumHeartbeat> alternativeHeartbeats = new AtomicReference();

    public void observeDefaultHeartbeat(@Observes @DefaultEngine DebeziumHeartbeat heartbeat) {
        this.defaultHeartbeats.set(heartbeat);
    }

    public void observeAlternativeHeartbeat(@Observes @Engine(value="alternative") DebeziumHeartbeat heartbeat) {
        this.alternativeHeartbeats.set(heartbeat);
    }

    public DebeziumHeartbeat get(String engine) {
        if (engine.equals("default")) {
            return this.defaultHeartbeats.get();
        }
        return this.alternativeHeartbeats.get();
    }
}

