/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.sample.app;

import io.debezium.runtime.Capturing;
import io.debezium.runtime.CapturingEvent;
import io.quarkus.sample.app.CaptureService;
import io.quarkus.sample.app.Product;
import jakarta.enterprise.context.ApplicationScoped;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CaptureHandler {
    private final CaptureService captureService;
    private final Logger logger = LoggerFactory.getLogger(CaptureHandler.class);

    public CaptureHandler(CaptureService captureService) {
        this.captureService = captureService;
    }

    @Capturing
    public void capture(CapturingEvent<SourceRecord> event) {
        this.captureService.capture();
    }

    @Capturing(destination="dbserver1.public.products")
    public void products(CapturingEvent<Product> event) {
        this.logger.info("getting an event from {}", (Object)event.destination());
        this.captureService.add((Product)event.record());
    }
}

