/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.sample.app.events;

import io.debezium.runtime.events.ConnectorStartedEvent;
import io.debezium.runtime.events.ConnectorStoppedEvent;
import io.debezium.runtime.events.PollingStartedEvent;
import io.debezium.runtime.events.PollingStoppedEvent;
import io.debezium.runtime.events.TasksStartedEvent;
import io.debezium.runtime.events.TasksStoppedEvent;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@ApplicationScoped
public class LifecycleEventObserver {
    private final List<Object> lifecycleEvents = new CopyOnWriteArrayList<Object>();

    void onConnectorStarted(@Observes ConnectorStartedEvent connectorStartedEvent) {
        this.lifecycleEvents.add(connectorStartedEvent);
    }

    void onConnectorStopped(@Observes ConnectorStoppedEvent connectorStoppedEvent) {
        this.lifecycleEvents.add(connectorStoppedEvent);
    }

    void onTaskStarted(@Observes TasksStartedEvent tasksStartedEvent) {
        this.lifecycleEvents.add(tasksStartedEvent);
    }

    void onTaskStopped(@Observes TasksStoppedEvent tasksStoppedEvent) {
        this.lifecycleEvents.add(tasksStoppedEvent);
    }

    void onPollingStarted(@Observes PollingStartedEvent pollingStartedEvent) {
        this.lifecycleEvents.add(pollingStartedEvent);
    }

    void onPollingStopped(@Observes PollingStoppedEvent pollingStoppedEvent) {
        this.lifecycleEvents.add(pollingStoppedEvent);
    }

    public List<Object> getLifecycleEvents() {
        return this.lifecycleEvents;
    }
}

