/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.deployment.engine;

import io.debezium.relational.CustomConverterRegistry;
import io.debezium.spi.converter.ConvertedField;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.debezium.deployment.engine.GeneratedConverterClassMetaData;
import io.quarkus.debezium.engine.relational.converter.QuarkusCustomConverter;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.util.HashUtil;
import java.util.UUID;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class CustomConverterGenerator {
    private final ClassOutput output;

    public CustomConverterGenerator(ClassOutput output) {
        this.output = output;
    }

    public GeneratedConverterClassMetaData generate(MethodInfo methodInfo, BeanInfo converter, BeanInfo filter) {
        String name = this.generateClassName(converter, methodInfo);
        try (ClassCreator quarkusCustomConverter = ClassCreator.builder().classOutput(this.output).className(name).interfaces(new Class[]{QuarkusCustomConverter.class}).build();){
            FieldDescriptor converterInstanceField = ((FieldCreator)quarkusCustomConverter.getFieldCreator("converter", methodInfo.declaringClass().name().toString()).setModifiers(2)).getFieldDescriptor();
            try (MethodCreator constructor = quarkusCustomConverter.getMethodCreator("<init>", Void.TYPE, new Class[]{Object.class});){
                constructor.setModifiers(1);
                constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), constructor.getThis(), new ResultHandle[0]);
                ResultHandle constructorThis = constructor.getThis();
                ResultHandle converterInstance = constructor.getMethodParam(0);
                constructor.writeInstanceField(converterInstanceField, constructorThis, converterInstance);
                constructor.returnValue(null);
            }
            try (MethodCreator convertMethod = quarkusCustomConverter.getMethodCreator("bind", CustomConverterRegistry.ConverterDefinition.class, new Class[]{ConvertedField.class});){
                ResultHandle convertThis = convertMethod.getThis();
                ResultHandle delegate = convertMethod.readInstanceField(converterInstanceField, convertThis);
                ResultHandle parameter = convertMethod.getMethodParam(0);
                MethodDescriptor methodDescriptor = MethodDescriptor.ofMethod((Object)methodInfo.declaringClass().toString(), (String)methodInfo.name(), CustomConverterRegistry.ConverterDefinition.class, (Object[])new Object[]{methodInfo.parameterType(0).name().toString()});
                ResultHandle resultHandle = convertMethod.invokeVirtualMethod(methodDescriptor, delegate, new ResultHandle[]{parameter});
                convertMethod.returnValue(resultHandle);
            }
            if (filter != null) {
                FieldDescriptor filterInstanceField = ((FieldCreator)quarkusCustomConverter.getFieldCreator("filter", filter.getImplClazz().name().toString()).setModifiers(2)).getFieldDescriptor();
                try (MethodCreator constructor = quarkusCustomConverter.getMethodCreator("<init>", Void.TYPE, new Class[]{Object.class, Object.class});){
                    constructor.setModifiers(1);
                    constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), constructor.getThis(), new ResultHandle[0]);
                    ResultHandle constructorThis = constructor.getThis();
                    ResultHandle converterInstance = constructor.getMethodParam(0);
                    constructor.writeInstanceField(converterInstanceField, constructorThis, converterInstance);
                    ResultHandle filterInstance = constructor.getMethodParam(1);
                    constructor.writeInstanceField(filterInstanceField, constructorThis, filterInstance);
                    constructor.returnValue(null);
                }
                try (MethodCreator filterMethod = quarkusCustomConverter.getMethodCreator("filter", Boolean.TYPE, new Class[]{ConvertedField.class});){
                    ResultHandle filterThis = filterMethod.getThis();
                    ResultHandle delegate = filterMethod.readInstanceField(filterInstanceField, filterThis);
                    ResultHandle parameter = filterMethod.getMethodParam(0);
                    MethodInfo delegateFilterMethod = filter.getImplClazz().method("filter", new Type[]{Type.create(ConvertedField.class)});
                    MethodDescriptor methodDescriptor = MethodDescriptor.ofMethod((Object)filter.getImplClazz().toString(), (String)delegateFilterMethod.name(), Boolean.TYPE, (Object[])new Object[]{delegateFilterMethod.parameterType(0).name().toString()});
                    ResultHandle resultHandle = filterMethod.invokeVirtualMethod(methodDescriptor, delegate, new ResultHandle[]{parameter});
                    filterMethod.returnValue(resultHandle);
                }
            }
            GeneratedConverterClassMetaData generatedConverterClassMetaData = new GeneratedConverterClassMetaData(UUID.randomUUID(), name.replace('/', '.'), converter, filter);
            return generatedConverterClassMetaData;
        }
    }

    private String generateClassName(BeanInfo bean, MethodInfo methodInfo) {
        return DotNames.internalPackageNameWithTrailingSlash((DotName)bean.getImplClazz().name()) + DotNames.simpleName((DotName)bean.getImplClazz().name()) + "_DebeziumCustomConverter_" + methodInfo.name() + "_" + HashUtil.sha1((String)(methodInfo.name() + "_" + methodInfo.returnType().name().toString()));
    }
}

