/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.debezium.deployment.engine;

import io.debezium.processors.spi.PostProcessor;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.debezium.deployment.engine.GeneratedClassMetaData;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.util.HashUtil;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.connect.data.Struct;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class PostProcessorGenerator {
    private final ClassOutput output;

    public PostProcessorGenerator(ClassOutput output) {
        this.output = output;
    }

    public GeneratedClassMetaData generate(MethodInfo methodInfo, BeanInfo beanInfo) {
        String name = this.generateClassName(beanInfo, methodInfo);
        try (ClassCreator invoker = ClassCreator.builder().classOutput(this.output).className(name).interfaces(new Class[]{PostProcessor.class}).build();){
            FieldDescriptor beanInstanceField = ((FieldCreator)invoker.getFieldCreator("beanInstance", methodInfo.declaringClass().name().toString()).setModifiers(2)).getFieldDescriptor();
            try (MethodCreator constructor = invoker.getMethodCreator("<init>", Void.TYPE, new Class[]{Object.class});){
                constructor.setModifiers(1);
                constructor.invokeSpecialMethod(MethodDescriptor.ofConstructor(Object.class, (Class[])new Class[0]), constructor.getThis(), new ResultHandle[0]);
                ResultHandle constructorThis = constructor.getThis();
                ResultHandle beanInstance = constructor.getMethodParam(0);
                constructor.writeInstanceField(beanInstanceField, constructorThis, beanInstance);
                constructor.returnValue(null);
            }
            try (MethodCreator apply = invoker.getMethodCreator("apply", Void.TYPE, new Class[]{Object.class, Struct.class});){
                ResultHandle applyThis = apply.getThis();
                ResultHandle delegate = apply.readInstanceField(beanInstanceField, applyThis);
                ResultHandle eventObject = apply.getMethodParam(0);
                ResultHandle eventStruct = apply.getMethodParam(1);
                MethodDescriptor methodDescriptor = MethodDescriptor.ofMethod((String)methodInfo.declaringClass().toString(), (String)methodInfo.name(), (String)"V", (String[])new String[]{methodInfo.parameterType(0).name().toString(), methodInfo.parameterType(1).name().toString()});
                apply.invokeVirtualMethod(methodDescriptor, delegate, new ResultHandle[]{eventObject, eventStruct});
                apply.returnVoid();
            }
            try (MethodCreator configure = invoker.getMethodCreator("configure", Void.TYPE, new Class[]{Map.class});){
                configure.setModifiers(1);
                configure.returnVoid();
            }
            try (MethodCreator close = invoker.getMethodCreator("close", Void.TYPE, new Class[0]);){
                close.setModifiers(1);
                close.returnVoid();
            }
        }
        return new GeneratedClassMetaData(UUID.randomUUID(), name.replace('/', '.'), beanInfo);
    }

    private String generateClassName(BeanInfo bean, MethodInfo methodInfo) {
        return DotNames.internalPackageNameWithTrailingSlash((DotName)bean.getImplClazz().name()) + DotNames.simpleName((DotName)bean.getImplClazz().name()) + "_DebeziumPostProcessor_" + methodInfo.name() + "_" + HashUtil.sha1((String)(methodInfo.name() + "_" + methodInfo.returnType().name().toString()));
    }
}

