/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.network.protocol.command;

import com.github.shyiko.mysql.binlog.GtidSet;
import com.github.shyiko.mysql.binlog.io.ByteArrayOutputStream;
import com.github.shyiko.mysql.binlog.network.protocol.command.Command;
import com.github.shyiko.mysql.binlog.network.protocol.command.CommandType;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class DumpBinaryLogGtidCommand
implements Command {
    private long serverId;
    private String binlogFilename;
    private long binlogPosition;
    private GtidSet gtidSet;

    public DumpBinaryLogGtidCommand(long serverId, String binlogFilename, long binlogPosition, GtidSet gtidSet) {
        this.serverId = serverId;
        this.binlogFilename = binlogFilename;
        this.binlogPosition = binlogPosition;
        this.gtidSet = gtidSet;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.writeInteger(CommandType.BINLOG_DUMP_GTID.ordinal(), 1);
        buffer.writeInteger(0, 2);
        buffer.writeLong(this.serverId, 4);
        buffer.writeInteger(this.binlogFilename.length(), 4);
        buffer.writeString(this.binlogFilename);
        buffer.writeLong(this.binlogPosition, 8);
        Collection<GtidSet.UUIDSet> uuidSets = this.gtidSet.getUUIDSets();
        int dataSize = 8;
        for (GtidSet.UUIDSet uuidSet : uuidSets) {
            dataSize += 24 + uuidSet.getIntervals().size() * 16;
        }
        buffer.writeInteger(dataSize, 4);
        buffer.writeLong(uuidSets.size(), 8);
        for (GtidSet.UUIDSet uuidSet : uuidSets) {
            buffer.write(DumpBinaryLogGtidCommand.hexToByteArray(uuidSet.getUUID().replace("-", "")));
            List<GtidSet.Interval> intervals = uuidSet.getIntervals();
            buffer.writeLong(intervals.size(), 8);
            for (GtidSet.Interval interval : intervals) {
                buffer.writeLong(interval.getStart(), 8);
                buffer.writeLong(interval.getEnd() + 1L, 8);
            }
        }
        return buffer.toByteArray();
    }

    private static byte[] hexToByteArray(String uuid) {
        byte[] b = new byte[uuid.length() / 2];
        int i = 0;
        int j = 0;
        while (j < uuid.length()) {
            b[i++] = (byte)Integer.parseInt(String.valueOf(uuid.charAt(j)) + uuid.charAt(j + 1), 16);
            j += 2;
        }
        return b;
    }
}

