/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers;

import io.debezium.testing.testcontainers.MongoDbContainer;
import io.debezium.testing.testcontainers.MongoDbDeployment;
import io.debezium.testing.testcontainers.MongoDbReplicaSet;
import io.debezium.testing.testcontainers.util.DockerUtils;
import io.debezium.testing.testcontainers.util.MoreStartables;
import io.debezium.testing.testcontainers.util.PortResolver;
import io.debezium.testing.testcontainers.util.RandomPortResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;

public class MongoDbShardedCluster
implements MongoDbDeployment {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbShardedCluster.class);
    private final int shardCount;
    private final int replicaCount;
    private final int routerCount;
    private final Network network;
    private final PortResolver portResolver;
    private final MongoDbReplicaSet configServers;
    private final List<MongoDbReplicaSet> shards;
    private final List<MongoDbContainer> routers;
    private final DockerImageName imageName;
    private volatile boolean started;

    public static Builder shardedCluster() {
        return new Builder();
    }

    private MongoDbShardedCluster(Builder builder) {
        this.shardCount = builder.shardCount;
        this.replicaCount = builder.replicaCount;
        this.routerCount = builder.routerCount;
        this.network = builder.network;
        this.portResolver = builder.portResolver;
        this.imageName = builder.imageName;
        this.shards = this.createShards();
        this.configServers = this.createConfigServers();
        this.routers = this.createRouters();
        DockerUtils.logDockerDesktopBanner(LOGGER, this.getHostNames(), builder.skipDockerDesktopLogWarning);
    }

    public void start() {
        if (this.started) {
            return;
        }
        LOGGER.info("Starting {} shard cluster...", (Object)this.shards.size());
        MoreStartables.deepStartSync(this.stream());
        this.addShards();
        this.started = true;
    }

    public void stop() {
        if (this.started) {
            LOGGER.info("Stopping {} shard cluster...", (Object)this.shards.size());
            MoreStartables.deepStopSync(this.stream());
            this.started = false;
        }
    }

    public int size() {
        return this.shards.size();
    }

    @Override
    public String getConnectionString() {
        return "mongodb://" + this.routers.stream().map(MongoDbContainer::getClientAddress).map(Objects::toString).collect(Collectors.joining(","));
    }

    public void enableSharding(String databaseName) {
        MongoDbContainer arbitraryRouter = this.routers.get(0);
        arbitraryRouter.eval("sh.enableSharding('" + databaseName + "')");
    }

    public void shardCollection(String databaseName, String collectionName, String keyField) {
        LOGGER.info("Enabling sharding for {}.{} using '{}' filed as key", new Object[]{databaseName, collectionName, keyField});
        MongoDbContainer arbitraryRouter = this.routers.get(0);
        arbitraryRouter.eval("sh.shardCollection('" + databaseName + "." + collectionName + "',{" + keyField + ":'hashed'})");
    }

    private List<MongoDbReplicaSet> createShards() {
        return IntStream.rangeClosed(1, this.shardCount).mapToObj(this::createShard).collect(Collectors.toList());
    }

    private MongoDbReplicaSet createShard(int i) {
        MongoDbReplicaSet shard = MongoDbReplicaSet.shardReplicaSet().network(this.network).namespace("test-mongo-shard" + i + "-replica").name("shard" + i).memberCount(this.replicaCount).portResolver(this.portResolver).skipDockerDesktopLogWarning(true).imageName(this.imageName).build();
        return shard;
    }

    private MongoDbReplicaSet createConfigServers() {
        MongoDbReplicaSet configServers = MongoDbReplicaSet.configServerReplicaSet().network(this.network).namespace("test-mongo-configdb").name("configdb").memberCount(this.replicaCount).portResolver(this.portResolver).configServer(true).skipDockerDesktopLogWarning(true).imageName(this.imageName).build();
        return configServers;
    }

    private List<MongoDbContainer> createRouters() {
        return IntStream.rangeClosed(1, this.routerCount).mapToObj(i -> this.createRouter(this.network, i)).collect(Collectors.toList());
    }

    private MongoDbContainer createRouter(Network network, int i) {
        MongoDbContainer router = MongoDbContainer.router(MongoDbShardedCluster.formatReplicaSetAddress(this.configServers, true)).network(network).name("test-mongos" + i).portResolver(this.portResolver).skipDockerDesktopLogWarning(true).imageName(this.imageName).build();
        router.getDependencies().addAll(this.shards);
        router.getDependencies().add(this.configServers);
        return router;
    }

    public void addShard() {
        MongoDbReplicaSet shard = this.createShard(this.shards.size() + 1);
        shard.start();
        this.addShard(shard);
        this.shards.add(shard);
    }

    public void removeShard() {
        MongoDbReplicaSet shard = this.shards.remove(this.shards.size() - 1);
        LOGGER.info("Removing shard: {}", (Object)shard.getName());
        MongoDbContainer arbitraryRouter = this.routers.get(0);
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).until(() -> arbitraryRouter.eval("db.adminCommand({removeShard: '" + shard.getName() + "'})").path("state").asText().equals("completed"));
        shard.stop();
    }

    private void addShards() {
        this.shards.forEach(this::addShard);
    }

    private void addShard(MongoDbReplicaSet shard) {
        String shardAddress = MongoDbShardedCluster.formatReplicaSetAddress(shard, false);
        LOGGER.info("Adding shard: {}", (Object)shardAddress);
        MongoDbContainer arbitraryRouter = this.routers.get(0);
        arbitraryRouter.eval("sh.addShard('" + shardAddress + "')");
        Awaitility.await().atMost(30L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).until(() -> MongoDbShardedCluster.stream(arbitraryRouter.eval("db.adminCommand({listShards: 1})").path("shards")).anyMatch(s -> s.get("_id").asText().equals(shard.getName()) && s.get("state").asInt() == 1));
    }

    private Stream<Startable> stream() {
        return Stream.concat(Stream.concat(this.shards.stream(), Stream.of(this.configServers)), this.routers.stream());
    }

    public List<String> getHostNames() {
        ArrayList<String> hostsEntries = new ArrayList<String>();
        this.routers.stream().map(MongoDbContainer::getNamedAddress).map(MongoDbContainer.Address::getHost).forEach(hostsEntries::add);
        this.shards.stream().map(MongoDbReplicaSet::getHostNames).forEach(hostsEntries::addAll);
        this.configServers.getHostNames().forEach(hostsEntries::add);
        return hostsEntries;
    }

    private static String formatReplicaSetAddress(MongoDbReplicaSet replicaSet, boolean namedAddress) {
        return replicaSet.getName() + "/" + replicaSet.getMembers().stream().map(namedAddress ? MongoDbContainer::getNamedAddress : MongoDbContainer::getClientAddress).map(Object::toString).collect(Collectors.joining(","));
    }

    public String toString() {
        return "MongoDbShardedCluster{configServers=" + this.configServers + ", shards=" + this.shards + ", routers=" + this.routers + ", started=" + this.started + "}";
    }

    private static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static class Builder {
        private int shardCount = 1;
        private int replicaCount = 1;
        private int routerCount = 1;
        private Network network = Network.newNetwork();
        private PortResolver portResolver = new RandomPortResolver();
        private boolean skipDockerDesktopLogWarning = false;
        private DockerImageName imageName;

        public Builder imageName(DockerImageName imageName) {
            this.imageName = imageName;
            return this;
        }

        public Builder shardCount(int shardCount) {
            this.shardCount = shardCount;
            return this;
        }

        public Builder replicaCount(int replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        public Builder routerCount(int routerCount) {
            this.routerCount = routerCount;
            return this;
        }

        public Builder network(Network network) {
            this.network = network;
            return this;
        }

        public Builder portResolver(PortResolver portResolver) {
            this.portResolver = portResolver;
            return this;
        }

        public Builder skipDockerDesktopLogWarning(boolean skipDockerDesktopLogWarning) {
            this.skipDockerDesktopLogWarning = skipDockerDesktopLogWarning;
            return this;
        }

        public MongoDbShardedCluster build() {
            return new MongoDbShardedCluster(this);
        }
    }
}

