/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers;

import io.debezium.testing.testcontainers.MongoDbContainer;
import io.debezium.testing.testcontainers.MongoDbDeployment;
import io.debezium.testing.testcontainers.util.DockerUtils;
import io.debezium.testing.testcontainers.util.MoreStartables;
import io.debezium.testing.testcontainers.util.PortResolver;
import io.debezium.testing.testcontainers.util.RandomPortResolver;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.Network;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class MongoDbReplicaSet
implements MongoDbDeployment {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbReplicaSet.class);
    private final String name;
    private final int memberCount;
    private final boolean configServer;
    private final Network network;
    private final PortResolver portResolver;
    private final List<MongoDbContainer> members = new ArrayList<MongoDbContainer>();
    private final DockerImageName imageName;
    private final boolean authEnabled;
    private final String rootUser;
    private final String rootPassword;
    private final Supplier<MongoDbContainer.Builder> nodeSupplier;
    private boolean started = false;

    public static Builder replicaSet() {
        return new Builder().nodeSupplier(MongoDbContainer::node);
    }

    public static Builder shardReplicaSet() {
        return new Builder().nodeSupplier(MongoDbContainer::shardServerNode);
    }

    public static Builder configServerReplicaSet() {
        return new Builder().nodeSupplier(MongoDbContainer::configServerNode);
    }

    private MongoDbReplicaSet(Builder builder) {
        this.nodeSupplier = builder.nodeSupplier;
        this.name = builder.name;
        this.memberCount = builder.memberCount;
        this.configServer = builder.configServer;
        this.network = builder.network;
        this.portResolver = builder.portResolver;
        this.imageName = builder.imageName;
        this.authEnabled = builder.authEnabled;
        this.rootUser = builder.rootUser;
        this.rootPassword = builder.rootPassword;
        for (int i = 1; i <= this.memberCount; ++i) {
            this.members.add(this.nodeSupplier.get().network(this.network).name(builder.namespace + i).replicaSet(this.name).portResolver(this.portResolver).skipDockerDesktopLogWarning(true).imageName(this.imageName).authEnabled(this.authEnabled).build());
        }
        DockerUtils.logDockerDesktopBanner(LOGGER, this.getHostNames(), builder.skipDockerDesktopLogWarning);
    }

    public String getName() {
        return this.name;
    }

    public Set<Startable> getDependencies() {
        return new HashSet<MongoDbContainer>(this.members);
    }

    @Override
    public String getConnectionString() {
        if (this.authEnabled) {
            return this.getAuthConnectionString(this.rootUser, this.rootPassword, "admin");
        }
        return this.getNoAuthConnectionString();
    }

    @Override
    public String getNoAuthConnectionString() {
        return this.getConnectionString(false, null, null, null);
    }

    @Override
    public String getAuthConnectionString(String username, String password, String authSource) {
        return this.getConnectionString(true, username, password, authSource);
    }

    private String getConnectionString(boolean useAuth, String username, String password, String authSource) {
        StringBuilder builder = new StringBuilder("mongodb://");
        if (useAuth) {
            builder.append(URLEncoder.encode(username, StandardCharsets.UTF_8)).append(":").append(URLEncoder.encode(password, StandardCharsets.UTF_8)).append("@");
        }
        String hosts = this.members.stream().map(MongoDbContainer::getClientAddress).map(Objects::toString).collect(Collectors.joining(","));
        builder.append(hosts).append("/?replicaSet=").append(this.name);
        if (useAuth) {
            builder.append("&").append("authSource=").append(authSource);
        }
        return builder.toString();
    }

    public List<MongoDbContainer> getMembers() {
        return this.members;
    }

    public void start() {
        if (this.started) {
            return;
        }
        LOGGER.info("[{}] Starting {} node replica set...", (Object)this.name, (Object)this.memberCount);
        MoreStartables.deepStartSync(this.getDependencies().stream());
        LOGGER.info("[{}] Initializing replica set...", (Object)this.name);
        this.initializeReplicaSet();
        LOGGER.info("[{}] Awaiting primary...", (Object)this.name);
        this.awaitReplicaPrimary();
        LOGGER.info("[{}] Creating root user...", (Object)this.name);
        this.createRootUser();
        this.started = true;
    }

    public void stop() {
        if (this.started) {
            LOGGER.info("[{}] Stopping...", (Object)this.name);
            MoreStartables.deepStopSync(this.members.stream());
            this.started = false;
        }
    }

    private void initializeReplicaSet() {
        MongoDbContainer arbitraryNode = this.members.get(0);
        MongoDbContainer.Address[] serverAddresses = (MongoDbContainer.Address[])this.members.stream().map(MongoDbContainer::getClientAddress).toArray(MongoDbContainer.Address[]::new);
        arbitraryNode.initReplicaSet(this.configServer, serverAddresses);
    }

    private void createRootUser() {
        if (this.authEnabled) {
            MongoDbContainer primary = this.tryPrimary().orElseThrow();
            primary.createUser(this.rootUser, this.rootPassword, "admin", true, "root");
        }
    }

    public void createUser(String username, String password, String database, String ... rolePairs) {
        MongoDbContainer primary = this.tryPrimary().orElseThrow();
        primary.createUser(username, password, database, false, rolePairs);
    }

    public Container.ExecResult execMongoScript(MountableFile file, String containerPath) {
        return this.tryPrimary().map(primary -> primary.execMongoScriptInContainer(file, containerPath)).orElseThrow();
    }

    public void awaitReplicaPrimary() {
        Awaitility.await().atMost(1L, TimeUnit.MINUTES).pollDelay(1L, TimeUnit.SECONDS).until(() -> this.tryPrimary().isPresent());
    }

    public void stepDown() {
        this.tryPrimary().ifPresent(MongoDbContainer::stepDown);
    }

    public void killPrimary() {
        this.tryPrimary().ifPresent(node -> {
            node.kill();
            this.members.remove(node);
        });
    }

    public Optional<MongoDbContainer> tryPrimary() {
        return MongoDbReplicaSet.stream(this.getStatus().path("members")).filter(memberStatus -> "PRIMARY".equals(memberStatus.path("stateStr").textValue())).findFirst().flatMap(this::findMember);
    }

    private Optional<MongoDbContainer> findMember(JsonNode memberStatus) {
        String name = memberStatus.path("name").textValue();
        return this.members.stream().filter(node -> node.getNamedAddress().toString().equals(name) || node.getClientAddress().toString().equals(name)).findFirst();
    }

    private JsonNode getStatus() {
        MongoDbContainer arbitraryNode = this.members.get(0);
        return arbitraryNode.eval("rs.status()");
    }

    public List<String> getHostNames() {
        return this.members.stream().map(MongoDbContainer::getNamedAddress).map(MongoDbContainer.Address::getHost).collect(Collectors.toList());
    }

    public MongoDbReplicaSet withStartupTimeout(Duration startupTimeout) {
        this.members.forEach(member -> member.withStartupTimeout(startupTimeout));
        return this;
    }

    public String toString() {
        return "MongoDbReplicaSet{name='" + this.name + "', memberCount=" + this.memberCount + ", configServer=" + this.configServer + ", network=" + this.network + ", members=" + this.members + ", started=" + this.started + "}";
    }

    private static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static class Builder {
        private String name = "rs0";
        private String namespace = "test-mongo";
        private int memberCount = 3;
        private boolean configServer = false;
        private Network network = Network.newNetwork();
        private PortResolver portResolver = new RandomPortResolver();
        private boolean skipDockerDesktopLogWarning = false;
        private DockerImageName imageName;
        private boolean authEnabled;
        private String rootUser = "root";
        private String rootPassword = "secret";
        private Supplier<MongoDbContainer.Builder> nodeSupplier = MongoDbContainer::node;

        public Builder nodeSupplier(Supplier<MongoDbContainer.Builder> nodeSupplier) {
            this.nodeSupplier = nodeSupplier;
            return this;
        }

        public Builder authEnabled(boolean authEnabled) {
            this.authEnabled = authEnabled;
            return this;
        }

        public Builder imageName(DockerImageName imageName) {
            this.imageName = imageName;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder memberCount(int memberCount) {
            this.memberCount = memberCount;
            return this;
        }

        public Builder configServer(boolean configServer) {
            this.configServer = configServer;
            return this;
        }

        public Builder network(Network network) {
            this.network = network;
            return this;
        }

        public Builder skipDockerDesktopLogWarning(boolean skipDockerDesktopLogWarning) {
            this.skipDockerDesktopLogWarning = skipDockerDesktopLogWarning;
            return this;
        }

        public Builder portResolver(PortResolver portResolver) {
            this.portResolver = portResolver;
            return this;
        }

        public Builder rootUser(String username, String password) {
            this.rootUser = username;
            this.rootPassword = password;
            return this;
        }

        public MongoDbReplicaSet build() {
            return new MongoDbReplicaSet(this);
        }
    }
}

