/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class MySqlTestResourceLifecycleManager
implements QuarkusTestResourceLifecycleManager {
    public static final String USER = "debezium";
    public static final String PASSWORD = "dbz";
    public static final String PRIVILEGED_USER = "mysqluser";
    public static final String PRIVILEGED_PASSWORD = "mysqlpassword";
    public static final String ROOT_PASSWORD = "debezium";
    public static final String DBNAME = "inventory";
    public static final String IMAGE = "debezium/example-mysql";
    public static final String HOST = "localhost";
    public static final Integer PORT = 3306;
    private static final GenericContainer<?> container = new GenericContainer("debezium/example-mysql").waitingFor((WaitStrategy)Wait.forLogMessage((String)".*mysqld: ready for connections.*", (int)2)).withEnv("MYSQL_ROOT_PASSWORD", "debezium").withEnv("MYSQL_USER", "mysqluser").withEnv("MYSQL_PASSWORD", "mysqlpassword").withExposedPorts(new Integer[]{PORT}).withStartupTimeout(Duration.ofSeconds(180L));

    public static GenericContainer<?> getContainer() {
        return container;
    }

    public Map<String, String> start() {
        container.start();
        ConcurrentHashMap<String, String> params = new ConcurrentHashMap<String, String>();
        params.put("debezium.source.connector.class", "io.debezium.connector.mysql.MySqlConnector");
        params.put("debezium.source.database.hostname", HOST);
        params.put("debezium.source.database.port", container.getMappedPort(PORT.intValue()).toString());
        params.put("debezium.source.database.user", "debezium");
        params.put("debezium.source.database.password", PASSWORD);
        params.put("debezium.source.database.dbname", DBNAME);
        return params;
    }

    public void stop() {
        try {
            if (container != null) {
                container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

