/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers;

import io.debezium.testing.testcontainers.ApicurioRegistryContainer;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ApicurioTestResourceLifeCycleManager
implements QuarkusTestResourceLifecycleManager {
    private static final ApicurioRegistryContainer container = new ApicurioRegistryContainer();
    private static final int APICURIO_PORT = 8080;

    public Map<String, String> start() {
        container.start();
        ConcurrentHashMap<String, String> params = new ConcurrentHashMap<String, String>();
        params.put("debezium.format.apicurio.registry.url", ApicurioTestResourceLifeCycleManager.getApicurioUrl());
        params.put("debezium.format.apicurio.registry.auto-register", "true");
        params.put("debezium.format.apicurio.registry.find-latest", "true");
        return params;
    }

    public void stop() {
        try {
            if (container != null) {
                container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getApicurioUrl() {
        return "http://" + container.getHost() + ":" + container.getMappedPort(8080) + "/apis/registry/v2";
    }
}

