/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.testcontainers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.debezium.testing.testcontainers.Connector;
import io.debezium.testing.testcontainers.ConnectorConfiguration;
import io.debezium.testing.testcontainers.ContainerImageVersions;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.awaitility.Awaitility;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class DebeziumContainer
extends GenericContainer<DebeziumContainer> {
    private static final String DEBEZIUM_VERSION = ContainerImageVersions.getStableVersion("debezium/connect");
    private static final int KAFKA_CONNECT_PORT = 8083;
    private static final String TEST_PROPERTY_PREFIX = "debezium.test.";
    public static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    protected static final OkHttpClient CLIENT = new OkHttpClient();

    public DebeziumContainer(DockerImageName containerImage) {
        super(containerImage);
        this.defaultConfig();
    }

    public DebeziumContainer(String containerImageName) {
        super(DockerImageName.parse((String)containerImageName));
        this.defaultConfig();
    }

    public static DebeziumContainer latestStable() {
        return new DebeziumContainer("debezium/connect:" + DEBEZIUM_VERSION);
    }

    private void defaultConfig() {
        this.setWaitStrategy(new LogMessageWaitStrategy().withRegEx(".*Session key updated.*").withStartupTimeout(Duration.of(60L, ChronoUnit.SECONDS)));
        this.withEnv("GROUP_ID", "1");
        this.withEnv("CONFIG_STORAGE_TOPIC", "debezium_connect_config");
        this.withEnv("OFFSET_STORAGE_TOPIC", "debezium_connect_offsets");
        this.withEnv("STATUS_STORAGE_TOPIC", "debezium_connect_status");
        this.withEnv("CONNECT_KEY_CONVERTER_SCHEMAS_ENABLE", "false");
        this.withEnv("CONNECT_VALUE_CONVERTER_SCHEMAS_ENABLE", "false");
        this.withExposedPorts(new Integer[]{8083});
    }

    public DebeziumContainer withKafka(KafkaContainer kafkaContainer) {
        return this.withKafka(kafkaContainer.getNetwork(), (String)kafkaContainer.getNetworkAliases().get(0) + ":9092");
    }

    public DebeziumContainer withKafka(Network network, String bootstrapServers) {
        this.withNetwork(network);
        this.withEnv("BOOTSTRAP_SERVERS", bootstrapServers);
        return (DebeziumContainer)this.self();
    }

    public DebeziumContainer enableApicurioConverters() {
        this.withEnv("ENABLE_APICURIO_CONVERTERS", "true");
        return (DebeziumContainer)this.self();
    }

    public static int waitTimeForRecords() {
        return Integer.parseInt(System.getProperty("debezium.test.records.waittime", "2"));
    }

    public String getTarget() {
        return "http://" + this.getContainerIpAddress() + ":" + this.getMappedPort(8083);
    }

    public String getConnectorsUri() {
        return this.getTarget() + "/connectors/";
    }

    public String getConnectorUri(String connectorName) {
        return this.getConnectorsUri() + connectorName;
    }

    public String getPauseConnectorUri(String connectorName) {
        return this.getConnectorUri(connectorName) + "/pause";
    }

    public String getResumeConnectorUri(String connectorName) {
        return this.getConnectorUri(connectorName) + "/resume";
    }

    public String getConnectorStatusUri(String connectorName) {
        return this.getConnectorUri(connectorName) + "/status";
    }

    public String getConnectorConfigUri(String connectorName) {
        return this.getConnectorUri(connectorName) + "/config";
    }

    public void registerConnector(String name, ConnectorConfiguration configuration) {
        Connector connector = Connector.from(name, configuration);
        this.executePOSTRequestSuccessfully(connector.toJson(), this.getConnectorsUri());
        Awaitility.await().atMost((long)DebeziumContainer.waitTimeForRecords() * 5L, TimeUnit.SECONDS).until(() -> this.isConnectorConfigured(connector.getName()));
    }

    public void updateOrCreateConnector(String name, ConnectorConfiguration newConfiguration) {
        this.executePUTRequestSuccessfully(newConfiguration.getConfiguration().toString(), this.getConnectorConfigUri(name));
        Awaitility.await().atMost((long)DebeziumContainer.waitTimeForRecords() * 5L, TimeUnit.SECONDS).until(() -> this.isConnectorConfigured(name));
    }

    private static void handleFailedResponse(Response response) {
        String responseBodyContent = "{empty response body}";
        try {
            ResponseBody responseBody = response.body();
            Throwable throwable = null;
            try {
                try {
                    if (null != responseBody) {
                        responseBodyContent = responseBody.string();
                    }
                    throw new IllegalStateException("Unexpected response: " + response + " ; Response Body: " + responseBodyContent);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (responseBody != null) {
                    if (throwable != null) {
                        try {
                            responseBody.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        responseBody.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error connecting to Debezium container", e);
        }
    }

    private void executePOSTRequestSuccessfully(String payload, String fullUrl) {
        RequestBody body = RequestBody.create((String)payload, (MediaType)JSON);
        Request request = new Request.Builder().url(fullUrl).post(body).build();
        try (Response response = CLIENT.newCall(request).execute();){
            if (!response.isSuccessful()) {
                DebeziumContainer.handleFailedResponse(response);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error connecting to Debezium container", e);
        }
    }

    private void executePUTRequestSuccessfully(String payload, String fullUrl) {
        RequestBody body = RequestBody.create((String)payload, (MediaType)JSON);
        Request request = new Request.Builder().url(fullUrl).put(body).build();
        try (Response response = CLIENT.newCall(request).execute();){
            if (!response.isSuccessful()) {
                DebeziumContainer.handleFailedResponse(response);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error connecting to Debezium container", e);
        }
    }

    protected static Response executeGETRequest(Request request) {
        try {
            return CLIENT.newCall(request).execute();
        }
        catch (IOException e) {
            throw new RuntimeException("Error connecting to Debezium container", e);
        }
    }

    protected static Response executeGETRequestSuccessfully(Request request) {
        Response response = DebeziumContainer.executeGETRequest(request);
        if (!response.isSuccessful()) {
            DebeziumContainer.handleFailedResponse(response);
        }
        return response;
    }

    public boolean connectorIsNotRegistered(String connectorName) {
        Request request = new Request.Builder().url(this.getConnectorUri(connectorName)).build();
        try (Response response = DebeziumContainer.executeGETRequest(request);){
            boolean bl = response.code() == 404;
            return bl;
        }
    }

    protected void deleteDebeziumConnector(String connectorName) {
        Request request = new Request.Builder().url(this.getConnectorUri(connectorName)).delete().build();
        DebeziumContainer.executeGETRequestSuccessfully(request).close();
    }

    public void deleteConnector(String connectorName) {
        this.deleteDebeziumConnector(connectorName);
        Awaitility.await().atMost((long)DebeziumContainer.waitTimeForRecords() * 5L, TimeUnit.SECONDS).until(() -> this.connectorIsNotRegistered(connectorName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getRegisteredConnectors() {
        Request request = new Request.Builder().url(this.getConnectorsUri()).build();
        try (ResponseBody responseBody = DebeziumContainer.executeGETRequestSuccessfully(request).body();){
            if (null == responseBody) return Collections.emptyList();
            List list = (List)MAPPER.readValue(responseBody.string(), (TypeReference)new TypeReference<List<String>>(){});
            return list;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error fetching list of registered connectors", e);
        }
    }

    public boolean isConnectorConfigured(String connectorName) {
        Request request = new Request.Builder().url(this.getConnectorUri(connectorName)).build();
        try (Response response = DebeziumContainer.executeGETRequest(request);){
            boolean bl = response.isSuccessful();
            return bl;
        }
    }

    public void ensureConnectorRegistered(String connectorName) {
        Awaitility.await().atMost((long)DebeziumContainer.waitTimeForRecords() * 5L, TimeUnit.SECONDS).until(() -> this.isConnectorConfigured(connectorName));
    }

    public void deleteAllConnectors() {
        List<String> connectorNames = this.getRegisteredConnectors();
        for (String connectorName : connectorNames) {
            this.deleteDebeziumConnector(connectorName);
        }
        Awaitility.await().atMost((long)DebeziumContainer.waitTimeForRecords() * 5L, TimeUnit.SECONDS).until(() -> this.getRegisteredConnectors().size() == 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connector.State getConnectorState(String connectorName) {
        Request request = new Request.Builder().url(this.getConnectorStatusUri(connectorName)).build();
        try (ResponseBody responseBody = DebeziumContainer.executeGETRequestSuccessfully(request).body();){
            if (null != responseBody) {
                ObjectNode parsedObject = (ObjectNode)MAPPER.readTree(responseBody.string());
                Connector.State state = Connector.State.valueOf(parsedObject.get("connector").get("state").asText());
                return state;
            }
            Connector.State state = null;
            return state;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error fetching connector state for connector: " + connectorName, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connector.State getConnectorTaskState(String connectorName, int taskNumber) {
        Request request = new Request.Builder().url(this.getConnectorStatusUri(connectorName)).get().build();
        try (ResponseBody responseBody = DebeziumContainer.executeGETRequestSuccessfully(request).body();){
            if (null != responseBody) {
                ObjectNode parsedObject = (ObjectNode)MAPPER.readTree(responseBody.string());
                Connector.State state = Connector.State.valueOf(parsedObject.get("tasks").get(taskNumber).get("state").asText());
                return state;
            }
            Connector.State state = null;
            return state;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error fetching connector task state for connector task: " + connectorName + "#" + taskNumber, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getConnectorConfigProperty(String connectorName, String configPropertyName) {
        Request request = new Request.Builder().url(this.getConnectorConfigUri(connectorName)).get().build();
        try (ResponseBody responseBody = DebeziumContainer.executeGETRequestSuccessfully(request).body();){
            if (null != responseBody) {
                ObjectNode parsedObject = (ObjectNode)MAPPER.readTree(responseBody.string());
                String string = parsedObject.get(configPropertyName).asText();
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error fetching connector config property for connector: " + connectorName, e);
        }
    }

    public void pauseConnector(String connectorName) {
        Request request = new Request.Builder().url(this.getPauseConnectorUri(connectorName)).put(RequestBody.create((String)"", (MediaType)JSON)).build();
        DebeziumContainer.executeGETRequestSuccessfully(request).close();
        Awaitility.await().atMost((long)DebeziumContainer.waitTimeForRecords() * 5L, TimeUnit.SECONDS).until(() -> this.getConnectorState(connectorName) == Connector.State.PAUSED);
    }

    public void resumeConnector(String connectorName) {
        Request request = new Request.Builder().url(this.getResumeConnectorUri(connectorName)).put(RequestBody.create((String)"", (MediaType)JSON)).build();
        DebeziumContainer.executeGETRequestSuccessfully(request).close();
        Awaitility.await().atMost((long)DebeziumContainer.waitTimeForRecords() * 5L, TimeUnit.SECONDS).until(() -> this.getConnectorState(connectorName) == Connector.State.RUNNING);
    }

    public void ensureConnectorState(String connectorName, Connector.State status) {
        Awaitility.await().atMost((long)DebeziumContainer.waitTimeForRecords() * 5L, TimeUnit.SECONDS).until(() -> this.getConnectorState(connectorName) == status);
    }

    public void ensureConnectorTaskState(String connectorName, int taskNumber, Connector.State status) {
        Awaitility.await().atMost((long)DebeziumContainer.waitTimeForRecords() * 5L, TimeUnit.SECONDS).until(() -> this.getConnectorTaskState(connectorName, taskNumber) == status);
    }

    public void ensureConnectorConfigProperty(String connectorName, String propertyName, String expectedValue) {
        Awaitility.await().atMost((long)DebeziumContainer.waitTimeForRecords() * 5L, TimeUnit.SECONDS).until(() -> Objects.equals(expectedValue, this.getConnectorConfigProperty(connectorName, propertyName)));
    }

    public static ConnectorConfiguration getPostgresConnectorConfiguration(PostgreSQLContainer<?> postgresContainer, int id, String ... options) {
        ConnectorConfiguration config = ConnectorConfiguration.forJdbcContainer(postgresContainer).with("database.server.name", "dbserver" + id).with("slot.name", "debezium_" + id);
        if (options != null && options.length > 0) {
            for (int i = 0; i < options.length; i += 2) {
                config.with(options[i], options[i + 1]);
            }
        }
        return config;
    }
}

