/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.operatorutil;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.OpenShiftUtils;
import io.debezium.testing.system.tools.fabric8.OperatorSubscriptionBuilder;
import io.debezium.testing.system.tools.kafka.builders.StrimziSubscriptionBuilder;
import io.debezium.testing.system.tools.operatorutil.OpenshiftOperatorEnum;
import io.debezium.testing.system.tools.registry.builders.ApicurioSubscriptionBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlan;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.Subscription;
import io.fabric8.openshift.client.OpenShiftClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperatorUtil.class);

    public static void deployOperator(OpenShiftClient ocp, OpenshiftOperatorEnum operatorEnum, String namespace) throws InterruptedException {
        OperatorSubscriptionBuilder sb;
        OpenShiftUtils utils = new OpenShiftUtils(ocp);
        utils.createOrReplaceOperatorGroup(namespace, operatorEnum.getOperatorGroupName());
        String startingCSV = null;
        if (operatorEnum == OpenshiftOperatorEnum.STRIMZI) {
            sb = StrimziSubscriptionBuilder.base().withConfig(ConfigProperties.PRODUCT_BUILD);
            if (!ConfigProperties.PRODUCT_BUILD) {
                startingCSV = operatorEnum.getStartingCSV();
                sb.withStartingCSV(startingCSV);
            }
        } else {
            sb = ApicurioSubscriptionBuilder.base().withConfig(ConfigProperties.PRODUCT_BUILD);
        }
        sb.withChannel(operatorEnum.getSubscriptionUpdateChannel()).withNamespace(namespace);
        Subscription subscription = sb.build();
        ((NonNamespaceOperation)ocp.operatorHub().subscriptions().inNamespace(namespace)).createOrReplace((Object)subscription);
        OperatorUtil.approveInstallPlan(ocp, namespace, subscription.getMetadata().getName(), startingCSV);
        utils.waitForOperatorDeploymentExists(namespace, operatorEnum);
    }

    public static void approveInstallPlan(OpenShiftClient ocp, String namespace, String subscriptionName, String startingCSV) {
        OpenShiftUtils utils = new OpenShiftUtils(ocp);
        utils.waitForInstallPlanExists(namespace, subscriptionName, startingCSV);
        InstallPlan plan = utils.installPlan(namespace, subscriptionName, startingCSV).orElseThrow();
        plan.getSpec().setApproved(Boolean.valueOf(true));
        ((NonNamespaceOperation)ocp.operatorHub().installPlans().inNamespace(namespace)).replace((Object)plan);
        LOGGER.info("Approved InstallPlan " + plan.getMetadata().getName() + " with CSV Names " + String.valueOf(plan.getSpec().getClusterServiceVersionNames()) + " for subscription: " + subscriptionName);
    }
}

