/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.certificateutil;

import io.debezium.testing.system.tools.certificateutil.CertificateExtensionWrapper;
import io.debezium.testing.system.tools.certificateutil.CertificateWrapper;
import io.debezium.testing.system.tools.certificateutil.CertificateWrapperBuilder;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateGenerator.class);
    private static final String SIGNATURE_ALGORITHM = "SHA384WITHRSA";
    private final X500Name caSubject = new X500Name("cn=RootCA");
    private final List<CertificateWrapperBuilder> certSpecs;
    private CertificateWrapper ca;
    private final List<CertificateWrapper> generatedCerts = new LinkedList<CertificateWrapper>();
    private final int PRIVATE_KEY_SIZE = 3072;
    private final String PRIVATE_KEY_ALGORITHM = "RSA";

    public CertificateGenerator(List<CertificateWrapperBuilder> leafSpec) {
        this.certSpecs = leafSpec;
    }

    public void generate() throws Exception {
        this.ca = this.generateCa();
        this.certSpecs.forEach(l -> {
            try {
                CertificateWrapper cert = this.genLeafCert((CertificateWrapperBuilder)l);
                this.generatedCerts.add(cert);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public KeyStore generateKeyStore(String leafName) throws Exception {
        CertificateWrapper certWrapper = this.getLeafCertificateWrapper(leafName);
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(null);
        keystore.setKeyEntry(leafName, certWrapper.getKeyPair().getPrivate(), "password".toCharArray(), new X509Certificate[]{this.holderToCert(certWrapper.getHolder()), this.holderToCert(this.ca.getHolder())});
        return keystore;
    }

    public CertificateWrapper getLeafCertificateWrapper(String name) {
        List spec = this.generatedCerts.stream().filter(l -> l.getName().equals(name)).collect(Collectors.toList());
        if (spec.size() != 1) {
            throw new IllegalArgumentException("Certificate not found in generated certs list");
        }
        return (CertificateWrapper)spec.get(0);
    }

    public CertificateWrapper getCa() {
        return this.ca;
    }

    private CertificateWrapper generateCa() throws IOException, NoSuchAlgorithmException {
        X509CertificateHolder certHolder;
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPair keyPair = this.generateKeyPair();
        long notBefore = System.currentTimeMillis();
        long notAfter = notBefore + 31536000000L;
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(this.caSubject, BigInteger.ONE, new Date(notBefore), new Date(notAfter), this.caSubject, keyPair.getPublic());
        List<CertificateExtensionWrapper> extensions = List.of(new CertificateExtensionWrapper(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true)), new CertificateExtensionWrapper(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(4)));
        try {
            extensions.forEach(arg_0 -> CertificateGenerator.lambda$generateCa$2((X509v3CertificateBuilder)certBuilder, arg_0));
            ContentSigner signer = new JcaContentSignerBuilder(SIGNATURE_ALGORITHM).build(keyPair.getPrivate());
            certHolder = certBuilder.build(signer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return CertificateWrapper.builder().withKeyPair(keyPair).withExtensions(extensions).withSubject(new String(this.caSubject.getEncoded())).withHolder(certHolder).build();
    }

    private CertificateWrapper genLeafCert(CertificateWrapperBuilder builder) throws OperatorCreationException, NoSuchAlgorithmException {
        KeyPair keyPair = this.generateKeyPair();
        long notBefore = System.currentTimeMillis();
        long notAfter = notBefore + 31536000000L;
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(this.caSubject, new BigInteger(String.valueOf(System.currentTimeMillis())), new Date(notBefore), new Date(notAfter), new X500Name(builder.getSubject()), keyPair.getPublic());
        builder.getExtensions().forEach(arg_0 -> CertificateGenerator.lambda$genLeafCert$3((X509v3CertificateBuilder)certBuilder, arg_0));
        ContentSigner signer = new JcaContentSignerBuilder(SIGNATURE_ALGORITHM).build(this.ca.getKeyPair().getPrivate());
        X509CertificateHolder holder = certBuilder.build(signer);
        return builder.withKeyPair(keyPair).withHolder(holder).build();
    }

    private X509Certificate holderToCert(X509CertificateHolder holder) throws CertificateException {
        JcaX509CertificateConverter converter = new JcaX509CertificateConverter();
        converter.setProvider((Provider)new BouncyCastleProvider());
        return converter.getCertificate(holder);
    }

    private KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(3072, new SecureRandom());
        return keyPairGenerator.generateKeyPair();
    }

    private static /* synthetic */ void lambda$genLeafCert$3(X509v3CertificateBuilder certBuilder, CertificateExtensionWrapper e) {
        try {
            certBuilder.addExtension(e.getIdentifier(), e.isCritical(), e.getValue());
        }
        catch (CertIOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static /* synthetic */ void lambda$generateCa$2(X509v3CertificateBuilder certBuilder, CertificateExtensionWrapper e) {
        try {
            certBuilder.addExtension(e.getIdentifier(), e.isCritical(), e.getValue());
        }
        catch (CertIOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

