/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka;

import com.github.dockerjava.api.command.InspectContainerResponse;
import io.debezium.testing.system.tools.WaitConditions;
import io.debezium.testing.system.tools.kafka.ConnectorConfigBuilder;
import io.debezium.testing.system.tools.kafka.KafkaConnectController;
import io.debezium.testing.system.tools.kafka.connectors.ConnectorDeployer;
import io.debezium.testing.system.tools.kafka.connectors.ConnectorMetricsReader;
import io.debezium.testing.system.tools.kafka.connectors.JsonConnectorDeployer;
import io.debezium.testing.system.tools.kafka.connectors.RestPrometheusMetricReader;
import io.debezium.testing.system.tools.kafka.docker.KafkaConnectConainer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerKafkaConnectController
implements KafkaConnectController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerKafkaConnectController.class);
    private final KafkaConnectConainer container;
    private final OkHttpClient http;

    public DockerKafkaConnectController(KafkaConnectConainer container, OkHttpClient http) {
        this.container = container;
        this.http = http;
    }

    public KafkaConnectConainer getContainer() {
        return this.container;
    }

    @Override
    public void disable() {
        this.container.getDockerClient().pauseContainerCmd(this.container.getContainerId()).exec();
    }

    @Override
    public void destroy() {
        this.container.stop();
    }

    @Override
    public void restore() {
        if (this.container.getContainerId() == null) {
            this.container.start();
        } else {
            InspectContainerResponse.ContainerState state = this.container.getCurrentContainerInfo().getState();
            if (Boolean.TRUE.equals(state.getPaused())) {
                this.container.getDockerClient().unpauseContainerCmd(this.container.getContainerId()).exec();
            }
        }
    }

    @Override
    public void waitForCluster() {
        Awaitility.await().atMost(WaitConditions.scaled(5L), TimeUnit.MINUTES).until(() -> ((KafkaConnectConainer)this.container).isRunning());
    }

    @Override
    public void deployConnector(ConnectorConfigBuilder config) throws IOException, InterruptedException {
        this.getConnectorDeployer().deploy(config);
    }

    private ConnectorDeployer getConnectorDeployer() {
        return new JsonConnectorDeployer(this.getApiURL(), this.http);
    }

    @Override
    public void undeployConnector(String name) throws IOException {
        this.getConnectorDeployer().undeploy(name);
    }

    @Override
    public HttpUrl getApiURL() {
        return new HttpUrl.Builder().scheme("http").host(this.container.getHost()).port(this.container.getMappedPort(8083).intValue()).build();
    }

    public HttpUrl getMetricsURL() {
        return new HttpUrl.Builder().scheme("http").host(this.container.getHost()).port(this.container.getMappedPort(9404).intValue()).addPathSegment("metrics").build();
    }

    @Override
    public boolean undeploy() {
        this.container.stop();
        return !this.container.isRunning();
    }

    @Override
    public ConnectorMetricsReader getMetricsReader() {
        return new RestPrometheusMetricReader(this.getMetricsURL());
    }
}

