/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.sqlserver;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.databases.OcpSqlDatabaseController;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.openshift.client.OpenShiftClient;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpSqlServerController
extends OcpSqlDatabaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpSqlServerController.class);
    private static final String DB_INIT_SCRIPT_PATH = "/database-resources/sqlserver/inventory.sql";
    private static final String DB_INIT_SCRIPT_PATH_CONTAINER = "/tmp/inventory.sql";
    private final Path initScript;

    public OcpSqlServerController(Deployment deployment, List<Service> services, String dbType, OpenShiftClient ocp) {
        super(deployment, services, "sqlserver", ocp);
        try {
            this.initScript = Paths.get(this.getClass().getResource(DB_INIT_SCRIPT_PATH).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getPublicDatabaseUrl() {
        return "jdbc:" + this.getDatabaseType() + "://" + this.getPublicDatabaseHostname() + ":" + this.getPublicDatabasePort() + ";encrypt=false";
    }

    @Override
    public void initialize() throws InterruptedException {
        Pod pod = (Pod)((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.ocp.pods().inNamespace(this.project)).withLabel("deployment", this.name)).list()).getItems().get(0);
        ((PodResource)((NonNamespaceOperation)this.ocp.pods().inNamespace(this.project)).withName(pod.getMetadata().getName())).file(DB_INIT_SCRIPT_PATH_CONTAINER).upload(this.initScript);
        this.ocpUtils.executeCommand(this.deployment, this.project, true, "/opt/mssql-tools18/bin/sqlcmd", "-U", "sa", "-P", ConfigProperties.DATABASE_SQLSERVER_SA_PASSWORD, "-i", DB_INIT_SCRIPT_PATH_CONTAINER, "-C", "-N", "o");
    }
}

