/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.sqlserver;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.databases.AbstractDockerSqlDatabaseController;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.testcontainers.containers.MSSQLServerContainer;
import org.testcontainers.images.builder.Transferable;

public class DockerSqlServerController
extends AbstractDockerSqlDatabaseController<MSSQLServerContainer<?>> {
    private static final String DB_INIT_SCRIPT_PATH = "/database-resources/sqlserver/inventory.sql";
    private static final String DB_INIT_SCRIPT_PATH_CONTAINER = "/opt/inventory.sql";
    private final Path initScript;

    public DockerSqlServerController(MSSQLServerContainer<?> container) {
        super(container);
        try {
            this.initScript = Paths.get(this.getClass().getResource(DB_INIT_SCRIPT_PATH).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getDatabasePort() {
        return MSSQLServerContainer.MS_SQL_SERVER_PORT;
    }

    @Override
    public void initialize() throws InterruptedException {
        try {
            ((MSSQLServerContainer)this.container).copyFileToContainer(Transferable.of((byte[])Files.readAllBytes(this.initScript)), DB_INIT_SCRIPT_PATH_CONTAINER);
            ((MSSQLServerContainer)this.container).execInContainer(new String[]{"/opt/mssql-tools18/bin/sqlcmd", "-U", "sa", "-P", ConfigProperties.DATABASE_SQLSERVER_SA_PASSWORD, "-i", DB_INIT_SCRIPT_PATH_CONTAINER, "-C", "-N", "o"});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

